/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplySummaryFilterToSet;
import com.cognos.xqe.ast.olap.TNodeUnbCompensation;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class DistributeSummaryFilterToScopedSets
extends Transformation {
    public DistributeSummaryFilterToScopedSets() {
        this.mName = "DistributeSummaryFilterToScopedSets";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        List<String> scopedDataItemNames = summaryFilter.getScopedDataItemNames();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] cogMDXGroupNodes = mdxQuery.getDescendantsOfType(1027, false);
        HashMap projectedDataItemNameCogMDXGroupListMap = new HashMap();
        for (int j = 0; j < cogMDXGroupNodes.length; ++j) {
            String refDataItemName = (String)cogMDXGroupNodes[j].getPropertyValue("refDataItem");
            if (refDataItemName == null || refDataItemName.length() == 0) continue;
            if (projectedDataItemNameCogMDXGroupListMap.get(refDataItemName) == null) {
                projectedDataItemNameCogMDXGroupListMap.put(refDataItemName, new ArrayList());
            }
            ((ArrayList)projectedDataItemNameCogMDXGroupListMap.get(refDataItemName)).add(cogMDXGroupNodes[j]);
        }
        boolean enableLockOnRemoveNonDetailSets = false;
        for (String dataItemName : scopedDataItemNames) {
            ArrayList cogMDXGroupList = (ArrayList)projectedDataItemNameCogMDXGroupListMap.get(dataItemName);
            if (cogMDXGroupList == null) {
                node.throwInternalError("Internal Error.");
            }
            for (CogMDXGroup cogMDXGroup : cogMDXGroupList) {
                cogMDXGroup.throwOnInvalidChildCategories();
                TNodeApplySummaryFilterToSet ancestorTNode = (TNodeApplySummaryFilterToSet)cogMDXGroup.getAncestorOfType(1141);
                if (ancestorTNode != null && ancestorTNode.hasNestedSet() && (cogMDXGroup == ancestorTNode.getNestedSet() || cogMDXGroup.isAncestor(ancestorTNode.getNestedSet()))) continue;
                TNodeApplySummaryFilterToSet tNode = (TNodeApplySummaryFilterToSet)factory.createNode(1141, summaryFilter);
                tNode.setSummaryFilterId(node.getId());
                IXQEQueryNode tNodeUnbCompensation = cogMDXGroup.getAncestorOfType(1113);
                if (tNodeUnbCompensation != null && cogMDXGroup.isAncestor(tNodeUnbCompensation.getChild(1))) {
                    IXQEQueryNode unbalancedCompensationSet = tNodeUnbCompensation.getChild(1);
                    if (unbalancedCompensationSet.getType() == 1030) {
                        MDXHierInfo hierInfo = ((TNodeUnbCompensation)tNodeUnbCompensation).getHierarchyInfo();
                        IHierarchy hierarchy = null;
                        if (hierInfo.getNumProjectedHierarchies() > 0) {
                            hierarchy = hierInfo.getProjectedHierarchy(0);
                        }
                        IHierarchy diffHierarchy = null;
                        MDXHierInfo diffHierInfo = ((AbstractMDXSet)unbalancedCompensationSet.getChild(1)).getHierarchyInfo();
                        if (diffHierInfo.getNumProjectedHierarchies() > 0) {
                            diffHierarchy = diffHierInfo.getProjectedHierarchy(0);
                        }
                        unbalancedCompensationSet = hierarchy != null && hierarchy.isUnbalanced() && diffHierarchy != null && !diffHierarchy.getDimension().isMeasuresDimension() ? unbalancedCompensationSet.getChild(1) : unbalancedCompensationSet.getChild(0);
                    }
                    unbalancedCompensationSet.getChild(0).insertParent(tNode);
                    continue;
                }
                cogMDXGroup.getChild(0).insertParent(tNode);
                AbstractMDXSet nestedSet = this.getNestedSet(cogMDXGroup, factory);
                if (nestedSet == null) continue;
                IXQEQueryNode[] tNodes = nestedSet.getDescendantsOfType(1141, false);
                for (int j = 0; j < tNodes.length; ++j) {
                    IXQEQueryNode sftNode = tNodes[j];
                    sftNode.detachChildrenExceptFirst();
                    sftNode.extract();
                }
                tNode.addChild(nestedSet);
                nestedSet.insertParent(factory.createNode(1139, tNode));
                nestedSet.getParent().setPropertyValue("nestedSet", Boolean.TRUE);
                enableLockOnRemoveNonDetailSets = true;
            }
        }
        if (enableLockOnRemoveNonDetailSets) {
            environment.enableLockNodeQueryPlanning(1139);
        }
        node.setPropertyValue("SummaryFilterDistributed", Boolean.TRUE);
    }

    private AbstractMDXSet getNestedSet(CogMDXGroup cogMDXGroup, IXQENodeFactory factory) {
        MDXHierInfo nestedHierInfo;
        AbstractMDXSet nestedSet = null;
        if (cogMDXGroup.getNumberChildren() == 2 && (nestedHierInfo = ((AbstractMDXSet)cogMDXGroup.getChild(1)).getHierarchyInfo()) != null && nestedHierInfo.getNumberOfNonMeasureHierarchiesProjected() > 0) {
            nestedSet = (AbstractMDXSet)factory.deepCopyNode(cogMDXGroup.getChild(1));
            this.removeTNodeApplySummaryFilter(nestedSet);
        }
        return nestedSet;
    }

    private void removeTNodeApplySummaryFilter(IXQEQueryNode node) {
        for (int idx = 0; idx < node.getNumberChildren(); ++idx) {
            this.removeTNodeApplySummaryFilter(node.getChild(idx));
        }
        if (node.getType() == 1141) {
            node.detachChildrenExceptFirst();
            node.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("SummaryFilterDistributed") == Boolean.TRUE) {
            this.traceNodeCondition(false, "The summary filter has already been distributed.", trace);
            return false;
        }
        if (node.getPropertyValue("ValidateSummaryFilterConditionApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The ValidateSummaryFilterCondition transformation has not yet been applied to the target node.", trace);
            return false;
        }
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        List<String> scopedDataItemNames = summaryFilter.getScopedDataItemNames();
        if (scopedDataItemNames.isEmpty()) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter node does not have scope defined.", trace);
            return false;
        }
        if (scopedDataItemNames.size() > 0 && node.getPropertyValue("ValidateSummaryFilterScopeApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The ValidateSummaryFilterScope transformation has not yet been applied to the target node.", trace);
            return false;
        }
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can been applied to the target node.", trace);
        return true;
    }
}

