/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.summaryfilter.SFUtil;
import java.util.List;

public final class SetSummaryFilterScope
extends Transformation {
    public SetSummaryFilterScope() {
        this.mName = "Set Summary Filter Scope.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            AbstractMDXSet[] detailSets;
            for (AbstractMDXSet detailSet : detailSets = SFUtil.getProjectedDetails(edges[i])) {
                IXQEQueryNode parentGroupNest = detailSet.getAncestorOfTypes(new int[]{1027, 1026});
                String refDataItemName = (String)parentGroupNest.getPropertyValue("refDataItem");
                ((CogMDXSummaryFilter)node).addScopedDateItemName(refDataItemName);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        List<String> scopedDataItemNames = summaryFilter.getScopedDataItemNames();
        if (scopedDataItemNames.size() > 0) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter node has scope defined.", trace);
            return false;
        }
        if (summaryFilter.getDefaultScopeName().compareTo("detail") != 0) {
            this.traceNodeCondition(false, "The target CogMDXSummaryFilter node does not have for_detail scope. The default scope is for_report.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        boolean queryProjectsDetails = false;
        for (int i = 0; i < edges.length; ++i) {
            AbstractMDXSet[] detailSets = SFUtil.getProjectedDetails(edges[i]);
            if (detailSets.length == 0) continue;
            queryProjectsDetails = true;
            for (AbstractMDXSet detailSet : detailSets) {
                String refDataItemName;
                IXQEQueryNode parentGroupNest = detailSet.getAncestorOfTypes(new int[]{1027, 1026});
                if (parentGroupNest == null) {
                    detailSet.throwInternalError("Unabled to locate CogMDXGroup/Nest parent for detail set.");
                }
                if ((refDataItemName = (String)parentGroupNest.getPropertyValue("refDataItem")) != null && refDataItemName.length() != 0) continue;
                node.throwInternalError("The refDataItem property has not been set on the detail CogMDXGroup/Nest nodes that project hierarchy " + detailSet.getHierarchyInfo().getProjectedHierarchy(0).getUniqueName());
            }
        }
        if (!queryProjectsDetails) {
            this.traceNodeCondition(false, "The edges of the MDXQuery do not project any details.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target node.", trace);
        return true;
    }
}

