/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class ValidateSummaryFilterCondition
extends Transformation {
    public static final String PROP_APPLIED = "ValidateSummaryFilterConditionApplied";

    public ValidateSummaryFilterCondition() {
        this.mName = "Validate Summary Filter Condition.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXBooleanExpression condition = (AbstractMDXBooleanExpression)node.getChild(0);
        if (!condition.isConditionsOnValueExpressions()) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppSummFilterCondition);
        }
        node.setPropertyValue(PROP_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation has already been applied to the target node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target CogMDXSummaryFilter node are invalid.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target node.", trace);
        return true;
    }
}

