/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.summaryfilter;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.ArrayList;
import java.util.List;

public class ValidateSummaryFilterScopeForSingleQueryMasterDetail
extends Transformation {
    public static final String PROP_APPLIED = "ValidateSummaryFilterScopeForSingleMasterDetailQueryApplied";

    public ValidateSummaryFilterScopeForSingleQueryMasterDetail() {
        this.mName = "Transform Summary Filters For Sectioned Crosstab queries.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{1011};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = true;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getPropertyValue(PROP_APPLIED) != Boolean.TRUE;
        if (!status) {
            this.traceQueryCondition(status, "This transformation has already been applied.", trace);
            return status;
        }
        CogMDXSummaryFilter summaryFilter = (CogMDXSummaryFilter)node;
        List<String> scopedDataItemNames = summaryFilter.getScopedDataItemNames();
        boolean bl2 = status = scopedDataItemNames.size() > 0;
        if (!status) {
            this.traceQueryCondition(status, "The summary filter does not have a scope.", trace);
            return status;
        }
        this.traceQueryCondition(status, "Query contains a scoped summary filter.", trace);
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean validationRequired;
        MDXQuery query = (MDXQuery)node.getAncestorOfType(1002);
        boolean bl = validationRequired = ((CogMDXSummaryFilter)node).getBooleanPropertyValue("fromUpgradedVDF") != Boolean.TRUE;
        if (validationRequired && query.isSingleQueryMasterDetail()) {
            ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
            messageContext.add(node);
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedSummaryFilterOnSingleQueryMasterDetail, messageContext);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        node.setPropertyValue(PROP_APPLIED, Boolean.TRUE);
    }
}

