/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.tagging;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.tagging.CogMDXGroupTagInfo;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public final class CollectTaggingInfoForEgde
extends Transformation {
    public static final String PROPERTY_TAGGING_LAST_GROUP_PROCESSED = "TaggingLastGroupProcessed";
    public static final Integer NO_GROUP_PROCESSED = XQEIntegerPool.getInteger(-1);

    public CollectTaggingInfoForEgde() {
        this.mName = "Collect tagging information for egde.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IXQEQueryNode> groupNodes = node.getDescendantsOfCategoryOrdered(1027, false);
        ArrayList<CogMDXGroup> discardedGroups = new ArrayList<CogMDXGroup>();
        HashMap<CogMDXGroup, CogMDXGroupTagInfo> taggingInfoByGroup = new HashMap<CogMDXGroup, CogMDXGroupTagInfo>();
        ListIterator<IXQEQueryNode> it = groupNodes.listIterator();
        int order = -1;
        int depth = -1;
        while (it.hasNext()) {
            CogMDXGroup ancestorGroup;
            CogMDXGroup group = (CogMDXGroup)it.next();
            if (!((MDXEdge)node).isProjectedDescendant(group)) {
                discardedGroups.add(group);
                it.remove();
                continue;
            }
            if (group.getType() == 1027) {
                boolean doDiscardGroup;
                boolean isInnerMostHierNormalization = group.isNormalizationGroup();
                if (isInnerMostHierNormalization && group.getNumberChildren() > 1) {
                    for (IXQEQueryNode nestedNode = group.getChild(1); nestedNode != null; nestedNode = nestedNode.getChild(1)) {
                        if (nestedNode.getType() == 1027 && ((CogMDXGroup)nestedNode).isNormalizationGroup() && nestedNode.getNumberChildren() > 1) {
                            continue;
                        }
                        if (nestedNode.getType() == 1027 && ((CogMDXGroup)nestedNode).isNormalizationGroup() && nestedNode.getNumberChildren() == 1) break;
                        isInnerMostHierNormalization = false;
                        break;
                    }
                }
                boolean isListDetailGroup = group.getRSAPIEdgeRowset() == null && group.getNumberChildren() > 1 && group.getChild(1).getType() == 1026;
                boolean bl = doDiscardGroup = isInnerMostHierNormalization || isListDetailGroup || group.getAncestorOfType(1080) != null;
                if (doDiscardGroup) {
                    discardedGroups.add(group);
                    it.remove();
                    continue;
                }
            }
            if ((ancestorGroup = (CogMDXGroup)group.getAncestorOfCategory(1027)) == null) {
                depth = 0;
            } else {
                CogMDXGroupTagInfo ancestorTaggingInfo;
                if (ancestorGroup.getFirstSetHierarchy().equals(group.getFirstSetHierarchy())) {
                    ancestorGroup.setIsNestedLevels(true);
                    group.setIsNestedLevels(true);
                }
                if ((ancestorTaggingInfo = (CogMDXGroupTagInfo)taggingInfoByGroup.get(ancestorGroup)) != null) {
                    depth = ancestorTaggingInfo.getDepth();
                    ++depth;
                } else {
                    depth = group.getAncestorsOfCategory(1027).length;
                }
            }
            Integer iDepth = XQEIntegerPool.getInteger(depth);
            group.setNumAncestorGroups(iDepth);
            IHierarchy hierarchy = null;
            AbstractMDXNode groupFirstChild = (AbstractMDXNode)group.getChild(0);
            MDXLevelInfo groupLevelInfo = groupFirstChild.getLevelInfo();
            if (groupLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() > 0) {
                hierarchy = groupLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
            }
            if (hierarchy == null || groupLevelInfo.getNumProjectedLevels(hierarchy) == 0) {
                discardedGroups.add(group);
                it.remove();
                continue;
            }
            if (!discardedGroups.isEmpty()) {
                ListIterator itDiscardedGroup = discardedGroups.listIterator();
                boolean discard = false;
                while (itDiscardedGroup.hasNext()) {
                    CogMDXGroup discardedGroup = (CogMDXGroup)itDiscardedGroup.next();
                    if (!group.isAncestor(discardedGroup)) continue;
                    discard = true;
                    break;
                }
                if (discard) {
                    discardedGroups.add(group);
                    it.remove();
                    continue;
                }
            }
            Integer orderKey = XQEIntegerPool.getInteger(++order);
            CogMDXGroupTagInfo groupTagInfo = new CogMDXGroupTagInfo(group, orderKey, groupLevelInfo, hierarchy, depth);
            taggingInfoByGroup.put(group, groupTagInfo);
        }
        node.setPropertyValue(PROPERTY_TAGGING_LAST_GROUP_PROCESSED, NO_GROUP_PROCESSED);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROPERTY_TAGGING_LAST_GROUP_PROCESSED) == null) {
            if (node.getDescendantsOfType(1027, false).length == 0) {
                this.traceNodeCondition(false, "The target MDXEdge node does not contain any CogMDXGroup nodes.", trace);
                return false;
            }
            this.traceNodeCondition(true, "The target MDXEdge node contains at least one CogMDXGroup node.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The transformation was already applied.", trace);
        return false;
    }
}

