/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.tagging;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.olap.edgemapping.FlagCogMDXGroupRequiringGenerateContextAction;
import com.cognos.xqe.transformation.olap.ragged_unbalanced.PrepareCompensationUnbalanced;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import java.util.Iterator;
import java.util.List;

public class IdentifyGroupsRequiringCurrentMemberProjection
extends Transformation {
    public IdentifyGroupsRequiringCurrentMemberProjection() {
        this.mName = "Identify CogMDXGroups that may require CURRENTMEMBER projection.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] childrenGroupsAndSumm;
        MDXSet ancestorSet;
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        IHierarchy targetHierarchy = targetGroup.getFirstSetHierarchy();
        if (targetHierarchy.getDimension().isMeasuresDimension()) {
            targetGroup.setGenerateProjCurrentMember(true);
            return;
        }
        MDXEdge edge = (MDXEdge)targetGroup.getAncestorOfType(1006);
        boolean useNLDecorationRules = edge.useNLDecorationRules(environment);
        if (!useNLDecorationRules) {
            targetGroup.setGenerateProjCurrentMember(true);
            return;
        }
        if (this.unsupportedReportSummaryPosition(targetGroup)) {
            targetGroup.setGenerateProjCurrentMember(true);
            return;
        }
        CogMDXGroup ancestorGroup = (CogMDXGroup)targetGroup.getAncestorOfCategory(1027);
        IHierarchy ancestorHierarchy = null;
        if (ancestorGroup != null) {
            ancestorHierarchy = ancestorGroup.getFirstSetHierarchy();
        }
        if (ancestorGroup != null && BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(ancestorGroup)) {
            targetGroup.setGenerateProjCurrentMember(true);
            return;
        }
        if (ancestorGroup != null && ancestorHierarchy.equals(targetHierarchy) && targetGroup.getHierarchyInfo().getNumProjectedHierarchies() > 1 && (ancestorSet = (MDXSet)targetGroup.getAncestorOfCategory(1039)) != null) {
            IHierarchy ancestorSetParentHierarchy;
            IXQEQueryNode ancestorSetParent;
            CogMDXGroup groupNestedUnderTargetGroup;
            IXQEQueryNode[] ancestorSetChildren = ancestorSet.getChildren();
            if (targetGroup.getChild(1).getType() == 1027 && targetGroup.getNumAncestorGroups() > 1 && !(groupNestedUnderTargetGroup = (CogMDXGroup)targetGroup.getChild(1)).getFirstSetHierarchy().equals(targetHierarchy) && BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(groupNestedUnderTargetGroup)) {
                IXQEQueryNode[] ancestorGroups;
                for (IXQEQueryNode currAncestor : ancestorGroups = targetGroup.getAncestorsOfCategory(1027)) {
                    if (currAncestor == ancestorGroup || !((CogMDXGroup)currAncestor).getFirstSetHierarchy().equals(ancestorHierarchy)) continue;
                    for (IXQEQueryNode mdxSetChild : ancestorSetChildren) {
                        if (targetGroup.isAncestor(mdxSetChild) || mdxSetChild.getType() == 1080) continue;
                        targetGroup.setGenerateProjCurrentMember(true);
                        return;
                    }
                }
            }
            if ((ancestorSetParent = ancestorSet.getParent()).isOfCategory(1027) && (ancestorSetParentHierarchy = ((CogMDXGroup)ancestorSetParent).getFirstSetHierarchy()).equals(targetHierarchy)) {
                int numAncestorGroups = 0;
                IXQEQueryNode ancestor = targetGroup;
                while (ancestor != ancestorSet && (ancestor = ancestor.getParent()) != ancestorSet) {
                    ++numAncestorGroups;
                }
                for (IXQEQueryNode mdxSetChild : ancestorSetChildren) {
                    if (targetGroup.isAncestor(mdxSetChild)) continue;
                    if (!mdxSetChild.isOfCategory(1027)) {
                        targetGroup.setGenerateProjCurrentMember(true);
                        return;
                    }
                    if (mdxSetChild.isOfCategory(1080) && ((CogMDXReportSummary)mdxSetChild).getFirstSetHierarchy().equals(targetHierarchy)) continue;
                    IXQEQueryNode nested = null;
                    for (int i = 0; i < numAncestorGroups; ++i) {
                        nested = mdxSetChild.getChild(1);
                        if (!nested.isOfCategory(1027)) {
                            targetGroup.setGenerateProjCurrentMember(true);
                            return;
                        }
                        if (!nested.isOfCategory(1080) || !((CogMDXReportSummary)nested).getFirstSetHierarchy().equals(targetHierarchy)) continue;
                        nested = null;
                        break;
                    }
                    if (nested == null || ((CogMDXGroup)nested).getFirstSetHierarchy().equals(targetHierarchy)) continue;
                    targetGroup.setGenerateProjCurrentMember(true);
                    return;
                }
            }
        }
        boolean result = true;
        if (FlagCogMDXGroupRequiringGenerateContextAction.isInnermostForHierarchy(targetGroup)) {
            result = this.isCurrentMemberRequiredInnerMostGroup(targetGroup, targetHierarchy);
            targetGroup.setGenerateProjCurrentMember(result);
            return;
        }
        if (targetGroup.getParent().getType() == 1039 && targetGroup.getParent().getNumberChildren() > 1 && (childrenGroupsAndSumm = targetGroup.getParent().getChildrenOfCategory(1027)).length != targetGroup.getParent().getNumberChildren()) {
            targetGroup.setGenerateProjCurrentMember(result);
            return;
        }
        result = this.isCurrentMemberRequired(targetGroup, targetHierarchy);
        if (!result && (targetHierarchy.isRagged() || targetHierarchy.isUnbalanced())) {
            result = this.isCurrentMemeberRequiredForRU(targetGroup, targetHierarchy, edge);
        }
        if (result) {
            IXQEQueryNode[] nestedGroups;
            for (IXQEQueryNode currGroup : nestedGroups = targetGroup.getDescendantsOfType(1027, false)) {
                IHierarchy currHierarchy = ((CogMDXGroup)currGroup).getFirstSetHierarchy();
                if (!currHierarchy.equals(targetHierarchy) || ((CogMDXGroup)currGroup).getGenerateProjCurrentMember()) continue;
                ((CogMDXGroup)currGroup).setGenerateProjCurrentMember(result);
            }
        }
        targetGroup.setGenerateProjCurrentMember(result);
    }

    private boolean isCurrentMemeberRequiredForRU(CogMDXGroup targetGroup, IHierarchy targetHierarchy, MDXEdge mdxEdge) {
        boolean result = false;
        if (!targetHierarchy.isRagged() && targetHierarchy.isUnbalanced()) {
            CogMDXGroup ancestorGroup = (CogMDXGroup)targetGroup.getAncestorOfCategory(1027);
            IHierarchy ancestorHierarchy = null;
            if (ancestorGroup != null) {
                ancestorHierarchy = ancestorGroup.getFirstSetHierarchy();
            }
            if (ancestorGroup == null || !ancestorHierarchy.equals(targetHierarchy)) {
                MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
                result = this.isUnbalancedCompensationRequired(targetGroup, targetHierarchy, mdxQuery);
            }
        } else if (targetHierarchy.isRagged()) {
            result = true;
        }
        return result;
    }

    private boolean isUnbalancedCompensationRequired(CogMDXGroup targetGroup, IHierarchy targetHierarchy, MDXQuery mdxQuery) {
        CogMDXGroup nextLevelNestedGroup;
        IHierarchy nestedHierarchy;
        boolean isUnbCompRequired = true;
        isUnbCompRequired = targetGroup.getNumberChildren() > 1 && PrepareCompensationUnbalanced.testChildren(targetGroup, targetHierarchy, mdxQuery, null, false);
        List<CogMDXGroup> nextLevelNestedGroups = targetGroup.getGroupsPrjAtNextDepthOrdered();
        Iterator<CogMDXGroup> iterator = nextLevelNestedGroups.iterator();
        while (iterator.hasNext() && (nestedHierarchy = (nextLevelNestedGroup = iterator.next()).getFirstSetHierarchy()).equals(targetHierarchy)) {
            if (nextLevelNestedGroup.getType() == 1080 || FlagCogMDXGroupRequiringGenerateContextAction.isInnermostForHierarchy(nextLevelNestedGroup)) continue;
            boolean isUnbCompRequiredForNested = this.isUnbalancedCompensationRequired(nextLevelNestedGroup, targetHierarchy, mdxQuery);
            isUnbCompRequired = !isUnbCompRequired && isUnbCompRequiredForNested || isUnbCompRequired && isUnbCompRequiredForNested;
        }
        return isUnbCompRequired;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        if (targetGroup.getPropertyValue("generateProjCurrentMember") != null) {
            this.traceNodeCondition(false, "Property 'generateProjCurrentMember' has been set already.", trace);
            return false;
        }
        MDXEdge edge = (MDXEdge)targetGroup.getAncestorOfType(1006);
        if (edge == null || !edge.isProjectedDescendant(targetGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup node is not projected on an edge.", trace);
            return false;
        }
        if (edge.getPropertyValue("TaggingLastGroupProcessed") == null) {
            this.traceNodeCondition(false, "Transformation CollectTaggingInfoForEgde was not applied yet to the ancestor edge.", trace);
            return false;
        }
        if (!targetGroup.validateChildCategories()) {
            this.traceNodeCondition(false, "At least one child node is invalid.", trace);
            return false;
        }
        if (targetGroup.getAncestorOfCategory(1080) != null) {
            this.traceNodeCondition(false, "The target CogMDXGroup node is nested under a CogMDXReportSummary node.", trace);
            return false;
        }
        List<CogMDXGroup> nextLevelNestedGroups = targetGroup.getGroupsPrjAtNextDepthOrdered();
        for (CogMDXGroup nextLevelNestedGroup : nextLevelNestedGroups) {
            if (nextLevelNestedGroup.getType() == 1080 || nextLevelNestedGroup.getPropertyValue("generateProjCurrentMember") != null) continue;
            this.traceNodeCondition(false, "Wait for the next level nested groups to be processed first.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target CogMDXGroup node may require the CURRENTMEMBER projection.", trace);
        return true;
    }

    public static boolean isMeasureOrRaggedOrUnbalanced(CogMDXGroup targetGroup) {
        IHierarchy targetHierarchy = targetGroup.getHierarchyInfo().getProjectedHierarchy(0);
        return targetHierarchy.isRagged() || targetHierarchy.isUnbalanced() || targetHierarchy.getDimension().isMeasuresDimension();
    }

    private boolean isCurrentMemberRequired(CogMDXGroup outerGroup, IHierarchy firstSetHierarchy) {
        MDXLevelInfo firstSetLevelInfo;
        AbstractMDXSet firstSet = (AbstractMDXSet)outerGroup.getChild(0);
        if (firstSet.getType() == 1113) {
            firstSet = (AbstractMDXSet)firstSet.getChild(0);
        }
        if ((firstSetLevelInfo = firstSet.getLevelInfo()).getNumProjectedLevels(firstSetHierarchy) > 1) {
            return true;
        }
        List<CogMDXGroup> nextLevelNestedGroups = outerGroup.getGroupsPrjAtNextDepthOrdered();
        if (!this.canNestedResolveItsContext(outerGroup, nextLevelNestedGroups)) {
            return true;
        }
        int summaryCount = 0;
        for (CogMDXGroup nextLevelNestedGroup : nextLevelNestedGroups) {
            if (nextLevelNestedGroup.getType() == 1080) {
                ++summaryCount;
                continue;
            }
            if (nextLevelNestedGroup.isNonDetailGroupBodyValue()) {
                return true;
            }
            if (!IdentifyGroupsRequiringCurrentMemberProjection.isOtherThanHierNormalizationOrCalculation(nextLevelNestedGroup) || !nextLevelNestedGroup.getGenerateProjCurrentMember()) continue;
            return true;
        }
        return summaryCount == nextLevelNestedGroups.size();
    }

    private boolean notSameHierNaturalOrderLevels(IHierarchy outerHierarchy, MDXLevelInfo outerLevelInfo, CogMDXGroup innerGroup) {
        MDXLevelInfo innerLevelInfo;
        boolean result = true;
        AbstractMDXSet innerSet = (AbstractMDXSet)innerGroup.getChild(0);
        MDXHierInfo innerHierInfo = innerSet.getHierarchyInfo();
        IHierarchy innerHierarchy = innerHierInfo.getProjectedHierarchy(0);
        if (outerHierarchy.equals(innerHierarchy) && (innerLevelInfo = innerSet.getLevelInfo()).getNumProjectedLevels(outerHierarchy) == 1 && outerLevelInfo.getNumProjectedLevels(outerHierarchy) == 1) {
            ILevel innerLevel = innerLevelInfo.getProjectedLevel(outerHierarchy, 0);
            ILevel outerLevel = outerLevelInfo.getProjectedLevel(outerHierarchy, 0);
            int innerLevelIndex = innerLevel.getIndex();
            int outerLevelIndex = outerLevel.getIndex();
            result = outerLevelIndex > innerLevelIndex;
        }
        return result;
    }

    private boolean isCurrentMemberRequiredInnerMostGroup(CogMDXGroup innermostGroup, IHierarchy innermostHierarchy) {
        if (!IdentifyGroupsRequiringCurrentMemberProjection.isOtherThanHierNormalizationOrCalculation(innermostGroup)) {
            return true;
        }
        CogMDXGroup nestedGroup = innermostGroup;
        AbstractMDXSet nestedFirstSet = (AbstractMDXSet)nestedGroup.getChild(0);
        int numOfAncestorWithSplitNesting = 0;
        for (CogMDXGroup ancestorGroup = (CogMDXGroup)innermostGroup.getAncestorOfCategory(1027); ancestorGroup != null; ancestorGroup = (CogMDXGroup)ancestorGroup.getAncestorOfCategory(1027)) {
            CogMDXGroup nested;
            IHierarchy nestedHierarchy;
            IHierarchy ancestorHierarchy;
            AbstractMDXSet firstSet = (AbstractMDXSet)ancestorGroup.getChild(0);
            if (firstSet.getType() == 1113) {
                firstSet = (AbstractMDXSet)firstSet.getChild(0);
            }
            if (!(ancestorHierarchy = ancestorGroup.getFirstSetHierarchy()).equals(innermostHierarchy)) break;
            MDXLevelInfo ancestorLevelInfo = firstSet.getLevelInfo();
            if (ancestorLevelInfo.getNumProjectedLevels(ancestorHierarchy) > 1) {
                return true;
            }
            List<CogMDXGroup> nestedOfGroupCategory = ancestorGroup.getGroupsPrjAtNextDepthOrdered();
            int numberOfSameHierCogMDXGroupUnderSameHierAncestor = 0;
            boolean foundSummariesUnderSameHierAncestor = false;
            Iterator<CogMDXGroup> iterator = nestedOfGroupCategory.iterator();
            while (iterator.hasNext() && (nestedHierarchy = (nested = iterator.next()).getFirstSetHierarchy()).equals(innermostHierarchy)) {
                if (nested.getType() == 1080) {
                    foundSummariesUnderSameHierAncestor = true;
                }
                if (nested.getType() != 1027 || ++numberOfSameHierCogMDXGroupUnderSameHierAncestor <= 1) continue;
                ++numOfAncestorWithSplitNesting;
                break;
            }
            if (firstSet.isSameExpression(nestedFirstSet, false) && foundSummariesUnderSameHierAncestor) {
                return true;
            }
            if (numOfAncestorWithSplitNesting > 1) {
                return true;
            }
            if (!this.canNestedResolveItsContext(ancestorGroup, nestedOfGroupCategory)) {
                return true;
            }
            if (this.notSameHierNaturalOrderLevels(ancestorHierarchy, ancestorLevelInfo, nestedGroup)) {
                return true;
            }
            if (this.unsupportedReportSummaryPosition(ancestorGroup)) {
                return true;
            }
            nestedGroup = ancestorGroup;
            nestedFirstSet = (AbstractMDXSet)nestedGroup.getChild(0);
        }
        return false;
    }

    private boolean unsupportedReportSummaryPosition(CogMDXGroup targetGroup) {
        if (targetGroup.getParent().getType() == 1039) {
            IXQEQueryNode[] siblings;
            for (IXQEQueryNode sibling : siblings = targetGroup.getParent().getChildren()) {
                if (sibling == targetGroup) break;
                if (sibling.getType() != 1080) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canNestedResolveItsContext(CogMDXGroup ancestorGroup, List<CogMDXGroup> nestedOfGroupCategory) {
        int summaryCount = 0;
        int currIdex = -1;
        for (CogMDXGroup nested : nestedOfGroupCategory) {
            ++currIdex;
            if (nested.getType() == 1080) {
                ++summaryCount;
                CogMDXReportSummary summary = (CogMDXReportSummary)nested;
                IXQEQueryNode detailExpr = summary.getDetailExpr();
                int detailExprIndex = nestedOfGroupCategory.indexOf(detailExpr);
                if (detailExprIndex != -1 && detailExprIndex <= currIdex) continue;
                return false;
            }
            if (((AbstractMDXSet)nested.getChild(0)).projectsOnlyCalculatedMembers(nested.getFirstSetHierarchy())) {
                return false;
            }
            if (nested.isNonDetailGroupBodyValue()) {
                return false;
            }
            if (nested.getRSAPIDataItemList() == null && (BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(nested) || CalcMemberReferencePrefixes.isNormalizationMeasure(nested.getChild(0)))) {
                return false;
            }
            if (nested.getRSAPIDataItemList() != null || !BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(nested)) continue;
            MDXEdge mdxEdge = (MDXEdge)ancestorGroup.getAncestorOfType(1006);
            MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
            if (mdxQuery.containsCrosstabSpacersOnEdge(mdxEdge.getEdgeID())) {
                return false;
            }
            IHierarchy hierarchy = nested.getFirstSetHierarchy();
            if (IdentifyGroupsRequiringCurrentMemberProjection.noNestedLevelCalculationsUnderSiblingGroups(nestedOfGroupCategory, hierarchy)) continue;
            return false;
        }
        return summaryCount != nestedOfGroupCategory.size();
    }

    private static boolean isOtherThanHierNormalizationOrCalculation(CogMDXGroup group) {
        IXQEQueryNode[] calcs;
        if (BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(group)) {
            return false;
        }
        if (BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(group)) {
            IHierarchy hierarchy;
            MDXEdge mdxEdge = (MDXEdge)group.getAncestorOfType(1006);
            MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
            if (mdxQuery.containsCrosstabSpacersOnEdge(mdxEdge.getEdgeID())) {
                return false;
            }
            List<CogMDXGroup> siblingsOfGroupCategory = null;
            CogMDXGroup ancestorGroup = (CogMDXGroup)group.getAncestorOfType(1027);
            if (ancestorGroup != null) {
                siblingsOfGroupCategory = ancestorGroup.getGroupsPrjAtNextDepthOrdered();
            }
            if (siblingsOfGroupCategory != null && !IdentifyGroupsRequiringCurrentMemberProjection.noNestedLevelCalculationsUnderSiblingGroups(siblingsOfGroupCategory, hierarchy = group.getFirstSetHierarchy())) {
                return false;
            }
        }
        if (group.getType() == 1080) {
            return false;
        }
        for (IXQEQueryNode calc : calcs = group.getChild(0).getDescendantsOfType(1013, false)) {
            if (!group.isProjectedDescendant((AbstractMDXNode)calc)) continue;
            return false;
        }
        return true;
    }

    private static boolean noNestedLevelCalculationsUnderSiblingGroups(List<CogMDXGroup> siblingGroups, IHierarchy hierarchy) {
        for (CogMDXGroup siblingGroup : siblingGroups) {
            if (siblingGroup.getType() == 1080) {
                return false;
            }
            if (!BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(siblingGroup) || !siblingGroup.getFirstSetHierarchy().equals(hierarchy)) continue;
            List<CogMDXGroup> nestedGroups = siblingGroup.getGroupsPrjAtNextDepthOrdered();
            for (CogMDXGroup nestedGroup : nestedGroups) {
                if (nestedGroup.getType() == 1080) {
                    return false;
                }
                AbstractMDXSet nestedSet = (AbstractMDXSet)nestedGroup.getChild(0);
                if (nestedSet.getType() != 1039 || nestedSet.getNumberChildren() != 1 || nestedSet.getChild(0).getType() != 1013 || !((MDXCalculatedMemberReference)nestedSet.getChild(0)).isNestedLevelCalcRef()) continue;
                return false;
            }
        }
        return true;
    }
}

