/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.usage;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class NestedRaggedLevels
extends Transformation {
    public NestedRaggedLevels() {
        this.mName = "Nested Ragged Levels";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{1027, 1026};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "Node does not have two children.", trace);
            return false;
        }
        MDXHierInfo firstChildHierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        MDXHierInfo secondChildHierInfo = ((AbstractMDXSet)node.getChild(1)).getHierarchyInfo();
        if (firstChildHierInfo.getNumProjectedHierarchies() == 1 && firstChildHierInfo.getProjectedHierarchy(0).isRagged() && firstChildHierInfo.projectedHierarchiesOverlap(secondChildHierInfo)) {
            this.traceNodeCondition(true, "Both children project ragged hierarchies.", trace);
            return true;
        }
        this.traceNodeCondition(true, "Both children of node do not project same ragged hierarchy.", trace);
        return false;
    }
}

