/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.metadata.IMember;

public class CalcMemberReferencePrefixes {
    public static final String CALC_MEMBER = "_CM";
    public static final String V5_CALC_MEMBER = "_V5M";
    public static final String MDX_FILLER = "_FT";
    public static final String MDX_AGGREGATE = "_AG";
    public static final String MDX_ROOT_MEMBER = "_RM";
    public static final String MDX_DUMMY_NULL_MEASURE = "_NULL";
    public static final String MDX_NORMALIZATION_MEASURE = "_NMEASURE";
    public static final String MDX_REPORT_SUMMARY = "_RS";
    public static final String MDX_REPORT_SUMMARY_ROLLUP_NONE = "_RSNONE";
    public static final String MDX_TAG_MEMBER = "_T";
    public static final String MDX_MEMBER_DETAIL_FILTER = "_MDF";
    public static final String MDX_SLICER = "_SL";
    public static final String MDX_VALUE_DETAIL_FILTER = "_VDF";
    public static final String MDX_DUPLICATE_BASE_MEASURE = "_DBM";
    public static final String MDX_ALTERNATE_MEASURE = "_AM";
    public static final String MDX_SUMMARY_FILTER = "_SF";
    public static final String MDX_YK_ROOTMEMBER_REPLACEMENT = "_YK";
    private static final String FILLER_TAG_PREFIX = "XQE_FT";
    public static final String PROPERTY_IN_GROUPBODY = "_PROPGBODY";

    public static boolean isFillerTag(IMember member) {
        if (member == null || member.getName() == null) {
            return false;
        }
        return member.getName().startsWith(FILLER_TAG_PREFIX);
    }

    public static boolean isFillerTag(IXQEQueryNode node) {
        MDXCalculatedMemberReference calc;
        return node.getType() == 1039 && node.getNumberChildren() == 1 && node.getChild(0).getType() == 1013 && (calc = (MDXCalculatedMemberReference)node.getChild(0)).getUniqueName().contains("XQE") && calc.getUniqueName().contains(MDX_FILLER);
    }

    public static boolean isNormalizationMeasure(IXQEQueryNode node) {
        MDXCalculatedMemberReference calc;
        return node.getType() == 1039 && node.getNumberChildren() == 1 && node.getChild(0).getType() == 1013 && (calc = (MDXCalculatedMemberReference)node.getChild(0)).getUniqueName().contains("XQE") && calc.getUniqueName().contains(MDX_NORMALIZATION_MEASURE);
    }

    public static boolean isFillerMeasure(IXQEQueryNode node) {
        MDXCalculatedMemberReference calc;
        return node.getType() == 1039 && node.getNumberChildren() == 1 && node.getChild(0).getType() == 1013 && (calc = (MDXCalculatedMemberReference)node.getChild(0)).getUniqueName().contains("XQE") && calc.getUniqueName().contains(MDX_DUMMY_NULL_MEASURE);
    }

    public static boolean isTag(IMember member) {
        if (member == null || member.getName() == null) {
            return false;
        }
        StringBuilder tagPrefix = new StringBuilder("XQE");
        tagPrefix.append(MDX_TAG_MEMBER);
        tagPrefix.append(CALC_MEMBER);
        return member.getName().startsWith(tagPrefix.toString());
    }

    public static boolean isXQECalculation(IMember member) {
        if (member == null || member.getName() == null) {
            return false;
        }
        if (member.getName().startsWith("XQE") && member.getName().contains(CALC_MEMBER)) {
            return true;
        }
        return member.getUniqueName().contains("XQE") && member.getUniqueName().contains(CALC_MEMBER);
    }

    public static boolean isMDF(AbstractMDXMember member) {
        if (member == null || member.getType() != 1013) {
            return false;
        }
        if (((MDXCalculatedMemberReference)member).getDefinition().getPrefix() == null) {
            return false;
        }
        return ((MDXCalculatedMemberReference)member).getDefinition().getPrefix().equals(MDX_MEMBER_DETAIL_FILTER);
    }
}

