/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummaryExpr;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.transformation.olap.util.CMSolveOrderComparator;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Arrays;

public final class SolveOrderUtil {
    private static final int PROP_INT_MAX_MDX_SOLVE_ORDER = 65535;
    private static final int PROP_INT_MAX_V5_SOLVE_ORDER = 65535;
    private static final int PROP_INT_CUBE_CALC_SOLVE_ORDER = 0;
    private static final int PROP_INT_SLICER_CALC_SOLVE_ORDER = 1;
    private static final int PROP_INT_MEMBER_SOLVE_ORDER = 2;
    private static final int PROP_INT_SUMMARY_CALC_SOLVE_ORDER = 2;
    private static final int PROP_INT_RELATIVE_TIME_PTD_CHANGE_OR_GROWTH_SOLVE_ORDER = 0;
    private static final int PROP_INT_UNREFERENCED_SOLVE_ORDER = 3;
    private static final int PROP_INT_MIN_NORMALIZED_SOLVE_ORDER = 4;
    private static final int PROP_INT_INCREMENT_NORMALIZED_SOLVE_ORDER = 4;
    private static final int PROP_INT_UNDEFINED_MDX_SOLVE_ORDER = -8192;
    private static final int PROP_INT_UNDEFINED_V5_SOLVE_ORDER = 0;

    private SolveOrderUtil() {
    }

    public static int getMaxMDXSolveOrder() {
        return 65535;
    }

    public static int getMaxV5SolveOrder() {
        return 65535;
    }

    public static int getCubeCalcSolveOrder() {
        return 0;
    }

    public static int getSlicerCalcSolveOrder() {
        return 1;
    }

    public static int getMemberSolveOrder() {
        return 2;
    }

    public static int getUnreferencedSolveOrder() {
        return 3;
    }

    public static int getSummaryCalcSolveOrder() {
        return 2;
    }

    public static int getMinNormalizedSolveOrder() {
        return 4;
    }

    public static int getIncNormalizedSolveOrder() {
        return 4;
    }

    public static int getUndefinedMDXSolveOrder() {
        return -8192;
    }

    public static int getUndefinedV5DataItemRefSolveOrder() {
        return 0;
    }

    public static int getRelativeTimePTDChangeOrGrowthSolveOrder() {
        return 0;
    }

    public static IXQEQueryNode[] sortCMBySolveOrder(IXQEQueryNode[] definitions) {
        CMSolveOrderComparator bySO = new CMSolveOrderComparator();
        Arrays.sort(definitions, bySO);
        return definitions;
    }

    public static int getSolveOrder(IXQEQueryNode node) {
        if (node.getType() == 1005) {
            return ((MDXCalculatedMemberDefinition)node).getSolveOrder();
        }
        if (node.getType() == 1028) {
            return ((CogMDXReportSummaryExpr)node).getSolveOrder();
        }
        node.throwInternalError("Invalid node type, no solve order defined.");
        return 0;
    }

    public static Boolean isAbsoluteSolveOrder(IXQEQueryNode node) {
        if (node.getType() == 1005) {
            return ((MDXCalculatedMemberDefinition)node).isAbsoluteSolveOrder();
        }
        if (node.getType() == 1028) {
            return Boolean.FALSE;
        }
        node.throwInternalError("Invalid node type, no absolute solve order property.");
        return Boolean.FALSE;
    }

    public static int findSolveOrderOfGroup(CogMDXGroup groupNode) {
        int solveOrder = SolveOrderUtil.getUndefinedMDXSolveOrder();
        if (groupNode.getType() == 1080) {
            IXQEQueryNode[] childrenOfType = groupNode.getDescendantsOfType(1028, false);
            if (childrenOfType.length > 0) {
                solveOrder = SolveOrderUtil.getSolveOrder(childrenOfType[0]);
            }
        } else {
            IXQEQueryNode[] childrenOfType;
            for (IXQEQueryNode child : childrenOfType = groupNode.getDescendantsOfType(1013, false)) {
                MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)child;
                if (!groupNode.isProjectedDescendant(calcRef) || child.getAncestorOfCategory(1027) != groupNode) continue;
                if (solveOrder != SolveOrderUtil.getUndefinedMDXSolveOrder() && solveOrder != SolveOrderUtil.getSolveOrder(calcRef.getDefinition())) {
                    solveOrder = SolveOrderUtil.getUndefinedMDXSolveOrder();
                    break;
                }
                solveOrder = SolveOrderUtil.getSolveOrder(calcRef.getDefinition());
            }
        }
        return solveOrder;
    }

    public static int findSolveOrderOfAncestorCalc(IXQEQueryNode node) {
        int solveOrder = SolveOrderUtil.getUndefinedMDXSolveOrder();
        for (CogMDXGroup ancestor = (CogMDXGroup)node.getAncestorOfCategory(1027); ancestor != null && solveOrder == SolveOrderUtil.getUndefinedMDXSolveOrder(); ancestor = (CogMDXGroup)ancestor.getAncestorOfCategory(1027)) {
            solveOrder = SolveOrderUtil.findSolveOrderOfGroup(ancestor);
        }
        return solveOrder;
    }

    public static void setSolveOrder(IXQEQueryNode node, int solveOrder) {
        if (node.getType() == 1005) {
            ((MDXCalculatedMemberDefinition)node).setSolveOrder(solveOrder);
        } else if (node.getType() == 1028) {
            ((CogMDXReportSummaryExpr)node).setSolveOrder(XQEIntegerPool.getInteger(solveOrder));
        } else {
            node.throwInternalError("Invalid node type.");
        }
    }
}

