/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.normalization.OrderCogMDXNestNodesByHierarchyAndLevel;
import java.util.ArrayList;
import java.util.List;

public final class CheckHierarchyLevelOverlap
extends Transformation {
    public static final String TRANSFORMATION_APPLIED = "CheckHierarchyLevelOverlapApplied";

    public CheckHierarchyLevelOverlap() {
        this.mName = "Validate nested hierarchy levels.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean[] result = new boolean[]{false, false};
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        boolean restrictMultiLevelOverlap = false;
        ArrayList<CogMDXGroup> innermostGroupsByHier = new ArrayList<CogMDXGroup>();
        innermostGroupsByHier.add(targetGroup);
        IHierarchy currHierarchy = targetGroup.getFirstSetHierarchy();
        for (CogMDXGroup ancestorGroup = (CogMDXGroup)targetGroup.getAncestorOfType(1027); ancestorGroup != null; ancestorGroup = (CogMDXGroup)ancestorGroup.getAncestorOfType(1027)) {
            IHierarchy ancestorGroupHierarchy = ancestorGroup.getFirstSetHierarchy();
            if (ancestorGroupHierarchy.equals(currHierarchy)) continue;
            innermostGroupsByHier.add(ancestorGroup);
            currHierarchy = ancestorGroupHierarchy;
        }
        for (CogMDXGroup currInnermost : innermostGroupsByHier) {
            currHierarchy = currInnermost.getFirstSetHierarchy();
            ArrayList<IXQEQueryNode> context = new ArrayList<IXQEQueryNode>();
            List<String> overlappingDataItems = OrderCogMDXNestNodesByHierarchyAndLevel.checkNestedHierarchyLevels(currInnermost, 1027, currHierarchy, result, environment, restrictMultiLevelOverlap, context);
            boolean isLevelsOverlap = result[1];
            if (!isLevelsOverlap || overlappingDataItems.isEmpty()) continue;
            String dataItemList = OrderCogMDXNestNodesByHierarchyAndLevel.generateParenthesisDelimitedList(overlappingDataItems);
            int aSeverity = 1;
            XQEMessage message = new XQEMessage(XQEMessageKeys.WRN_HierarchyLevelOverlap, currHierarchy.toString(), dataItemList, context);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, message));
        }
        targetGroup.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        if (targetGroup.getNumberChildren() == 1 && targetGroup.getAncestorOfType(1027) != null && targetGroup.getPropertyValue(TRANSFORMATION_APPLIED) == null) {
            this.traceNodeCondition(true, "Found the innermost group on its path.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The transformation either was already applied or is not required.", trace);
        return false;
    }
}

