/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;

public class ValidateWithinDetailSummary
extends Transformation {
    public ValidateWithinDetailSummary() {
        this.mName = "Throws if a within detail summary is detected at this point.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{201032};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node.getChild(1);
        String refDataItemName = (String)withinClause.getPropertyValue("refDataItemName");
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        messageContext.add(withinClause);
        XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedUseOfWithinDetailSummary, refDataItemName, messageContext);
        throw new XQERuntimeException(message);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (ValidateWithinDetailSummary.isWithinDetailV5Summary(node)) {
            this.traceNodeCondition(true, "The target V5MemberSummaryFunction is of within detail type.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The target V5MemberSummaryFunction is not of within detail type.", trace);
        return false;
    }

    public static boolean isWithinDetailV5Summary(IXQEQueryNode node) {
        V5AggregateWithinClause withinClause;
        return node.getChild(1).getType() == 201039 && (withinClause = (V5AggregateWithinClause)node.getChild(1)).getWithinClauseType() == 1;
    }
}

