/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;

public class BindDataSources
extends RQETransformation {
    public BindDataSources() {
        this(3);
    }

    public BindDataSources(int passNumber) {
        this.mName = "Bind data sources to query blocks.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        SQLQueryNode child = (SQLQueryNode)qBlock.getChild(0);
        ArrayList<IDataSource> dsList = new ArrayList<IDataSource>();
        child.getDataSourceList(environment.getExecutionEnvironment().getDataSources(), dsList);
        if (dsList.size() > 0) {
            qBlock.setDataSourceList(dsList);
            return;
        }
        qBlock.setDataSourceList(environment.getExecutionEnvironment().getDataSources());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLQueryBlock)node).getDataSourceList() == null;
        if (status) {
            this.traceQueryCondition(status, "Data sources have not been bound to the query block.", trace);
        } else {
            this.traceQueryCondition(status, "Data sources have already been bound to the query block.", trace);
        }
        return status;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getParent().getType() != 301004 && node.getParent().getType() != 301007;
        if (status) {
            this.traceQueryCondition(status, "Parent node is not a query block.", trace);
        } else {
            this.traceQueryCondition(status, "Parent node is a query block.", trace);
        }
        return status;
    }
}

