/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLSparqlQuery;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindNativeSQLException;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindRelationNotFoundException;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class BindSPARQLQuery
extends RQETransformation {
    public BindSPARQLQuery() {
        this(3);
    }

    public BindSPARQLQuery(int passNumber) {
        this.mName = "Bind SQLSparqlQUery node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301091};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) throws BindRelationNotFoundException {
        SQLSparqlQuery sparqlQuery = (SQLSparqlQuery)node;
        IDataSource dataSource = SQLBinderUtil.getDatasource(environment, sparqlQuery);
        if (!SQLBinderUtil.getMetaData(environment, sparqlQuery, dataSource, sparqlQuery.getQuery())) {
            throw new BindNativeSQLException(sparqlQuery.getQuery());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = (node.getPropertyValue("queryItems") == null || this.queryItemHasNullDataType((SQLQueryItemList)node.getPropertyValue("queryItems"))) && node.getAncestorOfType(301004) != null;
        if (status) {
            this.traceQueryCondition(status, "SPARQL query has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "SPARQL query has been bound.", trace);
        }
        return status;
    }

    private boolean queryItemHasNullDataType(SQLQueryItemList queryItems) {
        for (SQLQueryItem sqlQueryItem : queryItems) {
            if (sqlQueryItem.getDataType() != null) continue;
            return true;
        }
        return false;
    }
}

