/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IProcedure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IPhysicalProcArgument;
import com.cognos.xqe.metadata.IPhysicalProcResult;
import com.cognos.xqe.metadata.IPhysicalSubroutine;
import com.cognos.xqe.metadata.IProcParameter;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindAmbiguousRelationException;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindRelationNotFoundException;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class BindSQLCall
extends RQETransformation {
    public BindSQLCall() {
        this(3);
    }

    public BindSQLCall(int passNumber) {
        this.mName = "Bind SQLCall node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301061};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLCall call = (SQLCall)node;
        if (call.isUpdateSubject()) {
            SQLQueryItemList list = new SQLQueryItemList();
            call.setQueryItemList(list);
        } else {
            boolean status = this.bindUserDefinedStoredProcedure(node, environment);
            if (!status) {
                this.bindDatabaseStoredProcedure(node, environment);
            }
        }
        IDataSource ds = ((SQLCall)node).getDataSource();
        if (ds != null) {
            SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
            qBlock.setDataSource(ds);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLCall call = (SQLCall)node;
        boolean bl = status = call.getQueryItemList() == null;
        if (status) {
            this.traceQueryCondition(status, "Call procedure node has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Call procedure node has been bound.", trace);
        }
        return status;
    }

    public boolean bindDatabaseStoredProcedure(IXQEQueryNode node, IPlanningEnvironment environment) {
        try {
            return this.queryPhysicalModel(node, environment);
        }
        catch (BindRelationNotFoundException e) {
            if (!this.checkFromQS(node, (IExecutionEnvironment)environment.getExecutionEnvironment())) {
                throw e;
            }
            return true;
        }
    }

    private boolean bindUserDefinedStoredProcedure(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLCall fNode = (SQLCall)node;
        IProcedure function = null;
        IDataType[] argTypes = new IDataType[fNode.getNumberChildren()];
        for (int i = 0; i < fNode.getNumberChildren(); ++i) {
            if (fNode.getChild(i).getType() != 301031) continue;
            argTypes[i] = ((SQLLiteral)fNode.getChild(i)).getDataType();
        }
        try {
            function = (IProcedure)FunctionManager.getUserDefinedProcedure(fNode.getQualifiedName(), argTypes);
        }
        catch (XQERuntimeException e) {
            function = null;
        }
        if (function != null) {
            RowType rowType = (RowType)function.getResultDataType(null);
            int nColumns = rowType.getNumberColumns();
            SQLQueryItemList queryItems = new SQLQueryItemList(nColumns);
            for (int i = 0; i < nColumns; ++i) {
                SQLQueryItem itemDesc = new SQLQueryItem(rowType.getFieldName(i), rowType.getFieldDataType(i), i);
                queryItems.add(itemDesc);
            }
            fNode.setQueryItemList(queryItems);
            fNode.setFunction(function);
            return true;
        }
        return false;
    }

    private boolean queryPhysicalModel(IXQEQueryNode node, IPlanningEnvironment environment) throws BindRelationNotFoundException {
        SQLCall callNode = (SQLCall)node;
        IPhysicalSubroutine procedure = null;
        List<IMetadata> procedureList = null;
        IDataSource dataSource = null;
        Object mdConnection = environment.getMetadataConnection();
        Object executionEnv = environment.getExecutionEnvironment();
        String baseName = callNode.getName();
        String rawCmDatabaseName = callNode.getRawCmDatabaseName();
        String rawSchemaName = callNode.getRawSchemaName();
        String rawCatalogName = callNode.getRawCatalogName();
        if (rawCmDatabaseName != null) {
            dataSource = SQLBinderUtil.findOrCreateDataSource(environment, callNode);
            procedureList = mdConnection.getPhysicalMetadata(rawCmDatabaseName, rawCatalogName, rawSchemaName, baseName, false, true);
            if (procedureList.size() > 1) {
                procedureList = this.getSignatures(procedureList, callNode);
            }
            if (procedureList.isEmpty()) {
                throw new BindRelationNotFoundException(baseName);
            }
            if (procedureList.size() > 1) {
                throw new BindAmbiguousRelationException(baseName);
            }
            procedure = (IPhysicalSubroutine)procedureList.get(0);
        } else {
            Collection<IDataSource> dataSources = executionEnv.getDataSources();
            for (IDataSource ds : dataSources) {
                procedureList = mdConnection.getPhysicalMetadata(ds.getCMDataSourceName(), rawCatalogName, rawSchemaName, baseName, false, true);
                if (procedureList.size() > 1) {
                    procedureList = this.getSignatures(procedureList, callNode);
                }
                if (procedureList.size() > 1) {
                    throw new BindAmbiguousRelationException(baseName);
                }
                if (procedureList.size() == 1 && procedure != null) {
                    throw new BindAmbiguousRelationException(baseName);
                }
                if (procedureList.size() != 1) continue;
                procedure = (IPhysicalSubroutine)procedureList.get(0);
                dataSource = ds;
                break;
            }
            if (procedure == null) {
                throw new BindRelationNotFoundException(baseName);
            }
        }
        ConnectionUtil.connect(executionEnv, dataSource);
        boolean isCaseSensitive = SQLBinderUtil.determineCaseSensitivity(dataSource.getCapabilities());
        List<IPhysicalProcResult> procResults = procedure.getProcResults();
        SQLQueryItemList queryItems = new SQLQueryItemList(procResults.size());
        for (int i = 0; i < procResults.size(); ++i) {
            SQLQueryItem itemDesc = new SQLQueryItem();
            itemDesc.setSourceNo(0);
            itemDesc.setColumnNo(i);
            itemDesc.setName(procResults.get(i).getName());
            itemDesc.setDataType(procResults.get(i).getDataType());
            itemDesc.setCaseSensitivity(isCaseSensitive);
            queryItems.add(itemDesc);
        }
        callNode.setPropertyValue("queryItems", queryItems);
        List<IPhysicalProcArgument> procArgs = procedure.getProcArguments();
        queryItems = new SQLQueryItemList(procArgs.size());
        for (int i = 0; i < procArgs.size(); ++i) {
            SQLQueryItem itemDesc = new SQLQueryItem();
            itemDesc.setSourceNo(0);
            itemDesc.setColumnNo(i);
            itemDesc.setName(procArgs.get(i).getName());
            itemDesc.setDataType(procArgs.get(i).getDataType());
            itemDesc.setCaseSensitivity(isCaseSensitive);
            queryItems.add(itemDesc);
        }
        callNode.setPropertyValue("procArguments", queryItems);
        callNode.setDataSource(dataSource);
        return true;
    }

    private boolean checkFromQS(IXQEQueryNode node, IExecutionEnvironment executionEnv) {
        IQuerySubject qs = (IQuerySubject)node.getPropertyValue("querySubject");
        if (qs == null) {
            return false;
        }
        IDataSource dataSource = ((SQLCall)node).getDataSource();
        boolean isCaseSensitive = SQLBinderUtil.determineCaseSensitivity(dataSource.getCapabilities());
        List<IMetadata> queryItems = qs.getQueryItemsAndMeasures();
        SQLQueryItemList sqlQueryItems = new SQLQueryItemList(queryItems.size());
        for (int i = 0; i < queryItems.size(); ++i) {
            SQLQueryItem itemDesc = new SQLQueryItem();
            itemDesc.setSourceNo(0);
            itemDesc.setColumnNo(i);
            itemDesc.setName(queryItems.get(i).getName());
            itemDesc.setDataType(queryItems.get(i).getDataType());
            itemDesc.setCaseSensitivity(isCaseSensitive);
            sqlQueryItems.add(itemDesc);
        }
        node.setPropertyValue("queryItems", sqlQueryItems);
        List<IProcParameter> procArgs = qs.getStoredProcArgs();
        sqlQueryItems = new SQLQueryItemList(procArgs.size());
        for (int i = 0; i < procArgs.size(); ++i) {
            SQLQueryItem itemDesc = new SQLQueryItem();
            itemDesc.setSourceNo(0);
            itemDesc.setColumnNo(i);
            itemDesc.setName(procArgs.get(i).getParameterName());
            itemDesc.setDataType(procArgs.get(i).getDataType());
            itemDesc.setCaseSensitivity(isCaseSensitive);
            sqlQueryItems.add(itemDesc);
        }
        node.setPropertyValue("procArguments", sqlQueryItems);
        return true;
    }

    List<IMetadata> getSignatures(List<IMetadata> procList, SQLQueryNode node) {
        ArrayList<IMetadata> sigList = new ArrayList<IMetadata>();
        for (int i = 0; i < procList.size(); ++i) {
            IPhysicalSubroutine proc = (IPhysicalSubroutine)procList.get(i);
            List<IPhysicalProcArgument> procArgs = proc.getProcArguments();
            boolean status = this.compareArgumentDatatype(procArgs, node);
            if (!status) continue;
            sigList.add(proc);
            break;
        }
        return sigList;
    }

    private boolean compareArgumentDatatype(List<IPhysicalProcArgument> procArgs, SQLQueryNode node) {
        if (procArgs.size() == node.getNumberChildren()) {
            for (int j = 0; j < procArgs.size(); ++j) {
                SQLQueryNode child;
                IDataType dataType = procArgs.get(j).getDataType();
                if (DataTypeComparator.isComparableTo(dataType, (child = (SQLQueryNode)node.getChild(j)).getDataType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

