/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLColumnStar;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindRelationNotFoundException;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class BindSQLColumnStar
extends RQETransformation {
    public BindSQLColumnStar() {
        this(3);
    }

    public BindSQLColumnStar(int passNumber) {
        this.mName = "Bind SQLColumnStar.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301006};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryNode project = (SQLQueryNode)node.getGrandParent();
        String tableName = ((SQLColumnStar)node).getTableName();
        SQLQueryItemList itemList = project.getQueryItemList();
        boolean tableFound = false;
        for (int i = 0; i < itemList.size(); ++i) {
            SQLQueryItem item = (SQLQueryItem)itemList.get(i);
            String tName = item.getTableName();
            String cName = item.getName();
            if (tableName != null && (tName == null || !tName.equals(tableName))) continue;
            if (!item.isHidden()) {
                SQLFid fid = SQLBinderUtil.makeFid(environment, false, itemList, i);
                fid.setTableName(tName);
                fid.setName(cName);
                int pos = node.getParent().getPositionOfChild(node);
                node.getParent().addChild(fid, pos);
            }
            tableFound = true;
        }
        if (!tableFound) {
            throw new BindRelationNotFoundException(tableName);
        }
        node.extract();
    }
}

