/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class BindSQLJoin
extends RQETransformation {
    private static final String OLAP_DATATYPE_ADJUSTED = "OlapDataTypeAdjusted";

    public BindSQLJoin() {
        this(3);
    }

    public BindSQLJoin(int passNumber) {
        this.mName = "Bind SQLJoin node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLJoin jNode = (SQLJoin)node;
        SQLQueryItemList bindItems = jNode.getQueryItemList();
        if (this.needToBindJoinColumns(node)) {
            SQLBinderUtil.bindColumns(environment, jNode.getPredicate(), bindItems);
            jNode.setPropertyValue("queryItems", bindItems);
        }
        if (this.needToAdjustOlapDataType(node)) {
            for (SQLQueryItem queryItem : bindItems) {
                if (queryItem.getDataType().getSubType() != DataSubType.METADATATYPE) continue;
                queryItem.setDataType(DataTypeFactory.getVarcharType());
            }
            node.setPropertyValue(OLAP_DATATYPE_ADJUSTED, Boolean.TRUE);
        }
        jNode.setPropertyValue("leftCardinality", (Object)jNode.getLeftCardinality());
        jNode.setPropertyValue("rightCardinality", (Object)jNode.getRightCardinality());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = this.needToBindJoinColumns(node) || this.needToAdjustOlapDataType(node) || ((SQLJoin)node).getLeftCardinality() != null && ((SQLJoin)node).getPropertyValue("leftCardinality") == null || ((SQLJoin)node).getRightCardinality() != null && ((SQLJoin)node).getPropertyValue("rightCardinality") == null;
        if (status) {
            this.traceQueryCondition(status, "Join query block has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Join query block has been bound.", trace);
        }
        return status;
    }

    protected boolean needToBindJoinColumns(IXQEQueryNode node) {
        SQLJoin jNode = (SQLJoin)node;
        IXQEQueryNode parent = jNode.getParent();
        return jNode.getJoinType() != SQLJoin.SubType.CROSS && jNode.getPropertyValue("queryItems") == null && (parent.getType() == 301014 || parent.getType() == 301011);
    }

    protected boolean needToAdjustOlapDataType(IXQEQueryNode node) {
        return node.getPropertyValue("involvesMdxQuery") != null && node.getPropertyValue(OLAP_DATATYPE_ADJUSTED) == null;
    }
}

