/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class BindSQLQueryBlock
extends RQETransformation {
    public BindSQLQueryBlock() {
        this(3);
    }

    public BindSQLQueryBlock(int passNumber) {
        this.mName = "Bind SQLQueryBlock node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        SQLQueryItemList bindItems = child.getQueryItemList();
        if (qBlock.getBlockType() == 301011) {
            SQLBinderUtil.bindColumns(environment, qBlock, bindItems);
        }
        String tableName = qBlock.getName();
        List<String> nameList = qBlock.getDerivedColumnList();
        for (int i = 0; i < bindItems.size(); ++i) {
            SQLQueryItem qItem = (SQLQueryItem)bindItems.get(i);
            if (tableName != null) {
                qItem.setTableName(qBlock.getName());
            }
            if (nameList == null || nameList.size() == 0 || i >= nameList.size()) continue;
            qItem.setName(nameList.get(i));
        }
        qBlock.setQueryItemList(bindItems);
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 101016) {
            ((V5SqlQuery)parent).setQueryItemList(bindItems);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        int childType = node.getChild(0).getType();
        boolean bl = status = ((SQLQueryBlock)node).getQueryItemList() == null && childType != 301015 && childType != 301010 && childType != 301019;
        if (status) {
            this.traceQueryCondition(status, "Query block has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Query block has been bound.", trace);
        }
        return status;
    }
}

