/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class BindSQLSubQuery
extends RQETransformation {
    public BindSQLSubQuery() {
        this(3);
    }

    public BindSQLSubQuery(int passNumber) {
        this.mName = "Bind SQLSubQuery node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301059};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataType dataType;
        SQLSubQuery subQuery = (SQLSubQuery)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)subQuery.getChild(0);
        SQLQueryNode parent = (SQLQueryNode)node.getParent();
        SQLQueryItemList queryItems = qBlock.getQueryItemList();
        if (parent.getType() != 301055 && parent.getType() != 301054 && parent.getType() != 301076 && (parent.getType() != 301038 || ((SQLTableFunction)parent).getSubType() == SQLTableFunction.SubType.UNNEST)) {
            subQuery.setScalarSubQuery(true);
            dataType = ((SQLQueryItem)queryItems.get(0)).getDataType();
        } else {
            IDataType[] dataTypes = new IDataType[queryItems.size()];
            for (int i = 0; i < queryItems.size(); ++i) {
                SQLQueryItem item = (SQLQueryItem)queryItems.get(i);
                dataTypes[i] = item.getDataType();
            }
            dataType = queryItems.size() == 1 && dataTypes[0] instanceof RowType ? dataTypes[0] : DataTypeFactory.getRowType(dataTypes);
        }
        subQuery.setDataType(dataType);
        subQuery.setRewriteAsJoin(false);
        IXQEQueryNode dfNode = qBlock.getChild(0);
        while (!dfNode.isOfCategory(301015) && dfNode.getType() != 301012) {
            dfNode = dfNode.getChild(0);
        }
        List<IXQEQueryNode> xidList = dfNode.getDescendantsOfTypeOrdered(301082, 301004);
        subQuery.setCorrelatedSubQuery(xidList.size() > 0);
        if (environment.isBigSQL()) {
            Boolean rewrite = (Boolean)subQuery.getHint("rewrite");
            Boolean materialize = (Boolean)subQuery.getHint("materialize");
            if (subQuery.isCorrelatedSubQuery()) {
                subQuery.setRewriteAsJoin(true);
                if (rewrite != null && !rewrite.booleanValue()) {
                    subQuery.setRewriteAsJoin(false);
                }
                subQuery.removeHint("materialize");
            } else {
                if (parent.getType() == 301054) {
                    subQuery.setRewriteAsJoin(false);
                } else if (subQuery.isScalarSubQuery()) {
                    if (materialize != null && !materialize.booleanValue() || rewrite != null && rewrite.booleanValue()) {
                        subQuery.setRewriteAsJoin(true);
                    }
                } else {
                    subQuery.setRewriteAsJoin(true);
                    if (materialize != null && materialize.booleanValue() || rewrite != null && !rewrite.booleanValue()) {
                        subQuery.setRewriteAsJoin(false);
                    }
                }
                subQuery.getOrAddHints().put("materialize", true);
            }
            subQuery.removeHint("rewrite");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLSubQuery)node).getDataType() == null && ((SQLQueryBlock)node.getChild(0)).getQueryItemList() != null;
        if (status) {
            this.traceQueryCondition(status, "Data type of subquery has not been determined.", trace);
        } else {
            this.traceQueryCondition(status, "Data type of subquery has been determined.", trace);
        }
        return status;
    }
}

