/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLOption;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.config.ConfigService;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.SimpleDataSource;
import com.cognos.xqe.data.providers.SimpleDataSourceConnection;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.udf.IUDTableFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindTableFunctionNotFoundException;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.IQueryReuseManager;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public final class BindSQLTableFunction
extends RQETransformation {
    public BindSQLTableFunction() {
        this(3);
    }

    public BindSQLTableFunction(int passNumber) {
        this.mName = "Bind SQLTableFunction node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301038};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getParent();
        Object execEnv = environment.getExecutionEnvironment();
        Object reqEnv = environment.getRequestEnvironment();
        SQLTableFunction fNode = (SQLTableFunction)node;
        SQLQueryItemList queryItems = new SQLQueryItemList();
        queryItems.setParent(qBlock.getLateralQueryItemList());
        int nColumns = SQLBinderUtil.bindColumns(environment, node, queryItems);
        qBlock.setLateral(nColumns > 0);
        if (qBlock.isLateralDerivedTable()) {
            List<SQLXid> xidList = CollectionCast.downcast(node.getDescendantsOfTypeOrdered(301082, false), IXQEQueryNode.class, SQLXid.class);
            SQLQueryBlock pQueryBlock = qBlock;
            while (pQueryBlock.getParent().getType() != 301014 && pQueryBlock.getParent().getType() != 301011) {
                pQueryBlock = (SQLQueryBlock)pQueryBlock.getAncestorOfType(301004);
            }
            IXQEQueryNode parent = pQueryBlock.getParent();
            if (parent.getType() == 301011 && (((SQLJoin)parent).getJoinType() == SQLJoin.SubType.RIGHT_OUTER || ((SQLJoin)parent).getJoinType() == SQLJoin.SubType.FULL_OUTER)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidLateralDerivedTable);
            }
            pQueryBlock.setLateral(true);
            pQueryBlock = (SQLQueryBlock)pQueryBlock.getAncestorOfType(301004);
            pQueryBlock.addXidList(xidList);
        }
        List<String> nameList = qBlock.getDerivedColumnList();
        switch (fNode.getSubType()) {
            case XMLTABLE: 
            case JSON_TABLE: {
                Collection<IDataSource> dataSources = SQLBinderUtil.getDataSources(reqEnv, node);
                for (IDataSource ds : dataSources) {
                    if (ds == null || !ds.isRelational()) continue;
                    try {
                        ConnectionUtil.connect(execEnv, ds);
                    }
                    catch (Throwable throwable) {}
                }
                RowType dataType = (RowType)fNode.getDataType();
                fNode.setQueryItemList(this.getQueryItems(dataType, nameList));
                break;
            }
            case CURSOR: {
                SQLLiteral literal = (SQLLiteral)node.getChild(0);
                ObjectValue literalValue = (ObjectValue)literal.getValue();
                IQueryReuseManager.CursorInfo info = (IQueryReuseManager.CursorInfo)literalValue.getObject();
                SQLQueryItemList qil = info.getQueryItemList();
                RowType dataType = SQLBinderUtil.makeRowTypeFromQueryItems(qil);
                fNode.setDataType(dataType);
                fNode.setQueryItemList(this.getQueryItems(dataType, nameList));
                if (info.getCollation() == null) break;
                execEnv.registerDataSourceCollationInformation(info.getCollation(), null);
                break;
            }
            case DATASET: {
                String name = ((SQLRelation)node.getChild(0)).getName();
                String format = ((SQLLiteral)node.getChild(1)).getValue().getString();
                String location = null;
                if (node.getNumberChildren() > 2) {
                    location = ((SQLLiteral)node.getChild(2)).getValue().getString();
                }
                if (location == null) {
                    String path = reqEnv.getDatasetPath();
                    if (path != null && !path.equals("")) {
                        location = path;
                    } else {
                        location = ConfigService.getInstance().getDatasetServiceDirectory();
                        location = location.replace('\\', '/');
                    }
                }
                String dsName = name + "." + format.toLowerCase();
                String connectionString = String.format(";LOCAL;%s;URL=%s", format.toUpperCase(), location + File.separator + dsName);
                HashMap<String, Object> metadataProps = new HashMap<String, Object>();
                metadataProps.put("connectionString", connectionString);
                metadataProps.put("queryType", "relational");
                SimpleDataSourceConnection connection = new SimpleDataSourceConnection(connectionString, null);
                SimpleDataSource ds = new SimpleDataSource(name, format.toUpperCase(), connection, metadataProps);
                environment.getMultiRequestContext().addDataSource(ds);
                try {
                    Configuration configuration = FlintUtils.getHadoopConfiguration();
                    Path file = new Path(location, dsName);
                    File parquetFile = new File(file.toString());
                    parquetFile.setLastModified(Instant.now().getEpochSecond() * 1000L);
                    ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)configuration, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                    FileMetaData fileMetadata = metadata.getFileMetaData();
                    MessageType fileSchema = fileMetadata.getSchema();
                    RowType dataType = DataTypeFactory.getRowType();
                    for (int i = 0; i < fileSchema.getFieldCount(); ++i) {
                        Type field = fileSchema.getType(i);
                        IDataType dType = this.getDataType(field.asPrimitiveType());
                        dataType.addField(field.getName(), dType);
                    }
                    SQLRelation relationNode = (SQLRelation)environment.getNodeFactory().createNode(301016);
                    relationNode.setName(name);
                    relationNode.setDataSource(ds);
                    relationNode.setQueryItemList(this.getQueryItems(dataType, nameList));
                    long nRows = 0L;
                    for (BlockMetaData blockMetadata : metadata.getBlocks()) {
                        nRows += blockMetadata.getRowCount();
                    }
                    relationNode.setCardinality(nRows);
                    node.exchange(relationNode);
                    break;
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
            case UNNEST: {
                RowType dataType = DataTypeFactory.getRowType();
                SQLQueryNode qNode = (SQLQueryNode)node.getChild(0);
                String option = ((SQLOption)qNode).getValue();
                if (option.equals("WITH ORDINALITY")) {
                    dataType.addField(null, DataTypeFactory.getIntegerType());
                }
                int nChildren = node.getNumberChildren();
                for (int i = 1; i < nChildren; ++i) {
                    qNode = (SQLQueryNode)node.getChild(i);
                    IDataType dType = qNode.getDataType();
                    if (dType.getCCLTypeCode() == 103) {
                        RowType elementType = (RowType)((MultisetType)dType).getElementType();
                        for (int j = 0; j < elementType.getNumberColumns(); ++j) {
                            dataType.addField(elementType.getFieldName(j), elementType.getFieldDataType(j));
                        }
                        if (nChildren > 2) {
                            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentTypeCombinationForUnnestOperator);
                        }
                        if (!option.equals("WITH ORDINALITY")) continue;
                        throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidWithOrdinalityClauseForUnnestOperator);
                    }
                    if (dType.getCCLTypeCode() == 102) {
                        dataType.addField(null, ((ArrayType)dType).getElementType());
                        continue;
                    }
                    throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentTypeForUnnestOperator);
                }
                fNode.setDataType(dataType);
                fNode.setQueryItemList(this.getQueryItems(dataType, nameList));
                break;
            }
            default: {
                IUDTableFunction function = (IUDTableFunction)FunctionManager.getUserDefinedFunction(fNode.getFunctionName(), fNode.getParameterTypes());
                if (function == null) {
                    throw new BindTableFunctionNotFoundException(fNode.getFunctionName());
                }
                List<IDataType> types = qBlock.getDerivedColumnTypes();
                RowType dataType = types != null ? DataTypeFactory.getRowType(nameList.toArray(new String[0]), types.toArray(new IDataType[0])) : (RowType)function.getResultDataType(fNode);
                fNode.setDataType(dataType);
                fNode.setFunction(function);
                fNode.setQueryItemList(this.getQueryItems(dataType, nameList));
            }
        }
    }

    private IDataType getDataType(PrimitiveType type) {
        switch (type.getPrimitiveTypeName()) {
            case BINARY: {
                return DataTypeFactory.getVarcharType();
            }
            case INT32: {
                return DataTypeFactory.getIntegerType();
            }
            case INT64: {
                return DataTypeFactory.getLongType();
            }
            case FLOAT: {
                return DataTypeFactory.getFloatType();
            }
            case DOUBLE: {
                return DataTypeFactory.getDoubleType();
            }
        }
        throw new IllegalArgumentException();
    }

    private SQLQueryItemList getQueryItems(RowType dataType, List<String> nameList) {
        int nColumns = dataType.getNumberColumns();
        SQLQueryItemList queryItems = new SQLQueryItemList(nColumns);
        for (int i = 0; i < nColumns; ++i) {
            String name = nameList != null ? nameList.get(i) : dataType.getFieldName(i);
            queryItems.add(this.getQueryItem(name, dataType.getFieldDataType(i), i));
        }
        return queryItems;
    }

    private SQLQueryItem getQueryItem(String name, IDataType dType, int index) {
        SQLQueryItem qItem = new SQLQueryItem(name, dType, index);
        if (dType.getCCLTypeCode() == 104) {
            SQLQueryItemList attributes = new SQLQueryItemList();
            StructType sType = (StructType)dType;
            for (int j = 0; j < sType.getNumberColumns(); ++j) {
                attributes.add(this.getQueryItem(sType.getFieldName(j), sType.getFieldDataType(j), j));
            }
            qItem.setAttributeList(attributes);
        }
        return qItem;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = node.getPropertyValue("queryItems") == null;
        SQLTableFunction currentTableFnNode = (SQLTableFunction)node;
        if (currentTableFnNode.getSubType() == SQLTableFunction.SubType.JSON_TABLE && currentTableFnNode.getParent() instanceof SQLTableFunction && ((SQLTableFunction)currentTableFnNode.getParent()).getSubType() == SQLTableFunction.SubType.JSON_TABLE) {
            status = false;
        }
        if (status) {
            this.traceQueryCondition(status, "Table function has not been bound.", trace);
        } else {
            this.traceQueryCondition(status, "Table function has been bound.", trace);
        }
        return status;
    }
}

