/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.ArrayList;

public final class RemoveSQLAlias
extends RQETransformation {
    public RemoveSQLAlias() {
        this(4);
    }

    public RemoveSQLAlias(int passNumber) {
        this.mName = "Remove SQLAlias nodes.";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301030};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLValueList vList = (SQLValueList)node;
        int nChildren = vList.getNumberChildren();
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>(nChildren);
        for (int i = 0; i < nChildren; ++i) {
            node = vList.getChild(i);
            if (node.getType() != 301028) {
                aliasList.add(null);
                continue;
            }
            aliasList.add((SQLAlias)node);
            node.extract();
        }
        vList.setAliasList(aliasList);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getFirstChildByType(301028) != null;
        if (status) {
            this.traceQueryCondition(status, "Value list contains an expression with an alias.", trace);
        } else {
            this.traceQueryCondition(status, "Value list does not contain an expression with an alias.", trace);
        }
        return status;
    }
}

