/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.udf.IUDFunction;
import com.cognos.xqe.function.udf.IUDSQLFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class ReplaceSQLTableFunction
extends RQETransformation {
    public ReplaceSQLTableFunction() {
        this(0);
    }

    public ReplaceSQLTableFunction(int passNumber) {
        this.mName = "Replace SQLTableFunction node.";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301038};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLAbstractFunction fNode = (SQLAbstractFunction)node;
        IUDSQLFunction function = (IUDSQLFunction)FunctionManager.getUserDefinedFunction(fNode.getFunctionName(), fNode.getParameterTypes());
        IXQEQueryNode ast = factory.deepCopyNode(function.getSQLAst());
        IXQEQueryNode[] columnNodes = ast.getDescendantsOfType(301005, false);
        int i = 0;
        IXQEQueryNode[] children = node.getChildren();
        node.detachChildren();
        for (String argName : function.getArgumentNames()) {
            for (IXQEQueryNode cNode : columnNodes) {
                if (!((SQLColumn)cNode).getName().equals(argName)) continue;
                cNode.exchange(factory.deepCopyNode(children[i]));
            }
            ++i;
        }
        node.exchange(ast);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLAbstractFunction fNode = (SQLAbstractFunction)node;
        IUDFunction function = null;
        try {
            function = (IUDFunction)FunctionManager.getUserDefinedFunction(fNode.getFunctionName(), fNode.getParameterTypes());
        }
        catch (XQERuntimeException e) {
            function = null;
        }
        boolean bl = status = function != null && function.isSQLFunction();
        if (status) {
            this.traceQueryCondition(status, "Table function is a user-defined SQL expression.", trace);
        } else {
            this.traceQueryCondition(status, "Table function is not a user-defined SQL expression.", trace);
        }
        return status;
    }
}

