/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFieldRef;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.function.udf.IUDSQLFunction;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.transformation.relational.binding.ReplaceSQLFunction;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindAmbiguousColumnException;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindColumnNotFoundException;
import com.cognos.xqe.transformation.relational.binding.exceptions.BindInvalidArrayReferenceException;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.MapCast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;

public final class SQLBinderUtil {
    private static final String PROP_CM_DATA_SOURCE = "cmDataSource";
    private static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    public static final String PROP_OBJECT_DATASOURCE = "dataSource";
    public static final String DOT_OPEN_SQUARE_BRACKET = ".[";
    public static final String OPEN_SQUARE_BRACKET = "[";
    public static final String CLOSE_SQUARE_BRACKET = "]";
    public static final String CLOSE_OPEN_SQUARE_BRACKET = "].[";

    public static int bindColumns(IPlanningEnvironment environment, IXQEQueryNode parent, SQLQueryItemList itemList) {
        XQENodeFactory factory = environment.getNodeFactory();
        List<SQLColumn> columnList = CollectionCast.downcast(parent.getDescendantsOfTypeOrdered(301005, 301004), IXQEQueryNode.class, SQLColumn.class);
        for (SQLColumn node : columnList) {
            if (node.isPseudoColumn()) continue;
            SQLBinderUtil.bindIdentifierChain(environment, node, itemList);
        }
        List<SQLFieldRef> fieldList = CollectionCast.downcast(parent.getDescendantsOfTypeOrdered(301090, 301004), IXQEQueryNode.class, SQLFieldRef.class);
        for (SQLFieldRef fieldRef : fieldList) {
            String fieldName = fieldRef.getName();
            IDataType dType = ((SQLQueryNode)fieldRef.getChild(0)).getDataType();
            if (dType.getCCLTypeCode() != 104) {
                throw new BindColumnNotFoundException(fieldName);
            }
            StructType sType = (StructType)dType;
            SQLFid fid = null;
            for (int j = 0; j < sType.getNumberColumns(); ++j) {
                if (!sType.getFieldName(j).equalsIgnoreCase(fieldName)) continue;
                fid = (SQLFid)factory.createNode(301032);
                fid.setVirtualColumnNo(j);
                fid.setName(fieldName);
                fid.setDataType(sType.getFieldDataType(j));
                fieldRef.exchange(fid, true);
                break;
            }
            if (fid != null) continue;
            throw new BindColumnNotFoundException(fieldRef.getName());
        }
        return columnList.size();
    }

    private static void bindIdentifierChain(IPlanningEnvironment environment, SQLColumn node, SQLQueryItemList itemList) throws BindAmbiguousColumnException, BindColumnNotFoundException {
        byte cclType;
        String[] nameParts = node.getIdentifierChain();
        String catalogName = null;
        String schemaName = null;
        String tableName = null;
        String columnName = null;
        int fieldNo = -1;
        int columnNameIdx = -1;
        boolean outerRef = false;
        ArrayList<SQLFid> fieldList = new ArrayList<SQLFid>();
        while (true) {
            for (int i = 0; i < itemList.size(); ++i) {
                SQLQueryItem queryItem = (SQLQueryItem)itemList.get(i);
                String tName = queryItem.getTableName();
                String cName = queryItem.getName();
                if (cName == null) continue;
                String name = null;
                for (int j = nameParts.length - 1; j >= 0; --j) {
                    if (!SQLBinderUtil.compareIdentifiers(cName, nameParts[j], queryItem.isCaseSensitive())) continue;
                    name = nameParts[j];
                    columnNameIdx = j;
                    break;
                }
                if (name == null) continue;
                if (columnNameIdx > 2) {
                    catalogName = nameParts[0];
                }
                if (columnNameIdx > 1) {
                    schemaName = nameParts[columnNameIdx - 2];
                }
                if (node.getTableName() != null) {
                    tableName = node.getTableName();
                } else if (columnNameIdx > 0) {
                    tableName = nameParts[columnNameIdx - 1];
                }
                if (tName == null && tableName != null || tName != null && tableName != null && !SQLBinderUtil.compareIdentifiers(tName, tableName, queryItem.isCaseSensitive())) continue;
                fieldList.clear();
                boolean match = true;
                if (columnNameIdx < nameParts.length - 1) {
                    if (queryItem.getDataType().isMultiset()) continue;
                    SQLQueryItemList attributes = queryItem.getAttributeList();
                    block3: for (int j = columnNameIdx + 1; j < nameParts.length; ++j) {
                        match = false;
                        if (attributes == null) break;
                        for (int k = 0; k < attributes.size(); ++k) {
                            SQLQueryItem attribute = (SQLQueryItem)attributes.get(k);
                            if (!SQLBinderUtil.compareIdentifiers(attribute.getName(), nameParts[j], attribute.isCaseSensitive())) continue;
                            SQLFid fid = (SQLFid)environment.getNodeFactory().createNode(301032);
                            fid.setVirtualColumnNo(k);
                            fid.setName(attribute.getName());
                            fid.setDataType(attribute.getDataType());
                            fid.setIsNullable(attribute.isNullable());
                            fieldList.add(fid);
                            attributes = attribute.getAttributeList();
                            match = true;
                            continue block3;
                        }
                    }
                }
                if (!match) continue;
                if (fieldNo >= 0) {
                    throw new BindAmbiguousColumnException(name);
                }
                fieldNo = i;
                columnName = name;
            }
            if (fieldNo >= 0) break;
            if ((itemList = itemList.getParent()) == null) {
                if (node.getOriginalTableName() != null) {
                    throw new BindColumnNotFoundException(node.getName(), node.getOriginalTableName());
                }
                throw new BindColumnNotFoundException(node.getName());
            }
            outerRef = true;
        }
        boolean isArrayElementRef = node.getParent().getType() == 301046;
        SQLFid fid = SQLBinderUtil.makeFid(environment, outerRef, itemList, fieldNo);
        fid.setCatalogName(catalogName);
        fid.setSchemaName(schemaName);
        fid.setTableName(tableName);
        fid.setName(columnName);
        fid.setPropertyValue(PROP_OBJECT_DATASOURCE, node.getPropertyValue(PROP_OBJECT_DATASOURCE));
        node.getParent().exchangeChildNode(node, fid, false);
        if (fieldList.size() > 0) {
            for (SQLFid field : fieldList) {
                fid.insertParent(field);
                fid = field;
            }
        }
        if (isArrayElementRef && (cclType = fid.getDataType().getCCLTypeCode()) != 102 && cclType != 113) {
            throw new BindInvalidArrayReferenceException(columnName, tableName);
        }
    }

    public static void bindUserDefinedFunctions(IPlanningEnvironment environment, SQLQueryBlock qBlock) {
        Object executionEnv = environment.getExecutionEnvironment();
        List<SQLFunction> fList = CollectionCast.downcast(qBlock.getDescendantsOfTypeOrdered(301033, 301004), IXQEQueryNode.class, SQLFunction.class);
        Iterator<SQLFunction> fIterator = fList.iterator();
        while (fIterator.hasNext()) {
            if (fIterator.next().isUdf()) continue;
            fIterator.remove();
        }
        if (fList.size() == 0) {
            return;
        }
        for (int i = fList.size() - 1; i >= 0; --i) {
            SQLFunction fNode = fList.get(i);
            String fName = fNode.getFunctionName();
            IDataType[] pTypes = fNode.getParameterTypes();
            IDataType resultType = DataTypeFactory.getVariantType();
            MultiRequestContext mrcEnv = environment.getMultiRequestContext();
            if (mrcEnv.fetchBooleanConfiguration("queryPlanning.strictDBFunctionReturnType[@enabled]", false) || fNode.getPropertyValue("isColumn") != null) {
                resultType = fNode.getDataType();
            }
            boolean isDbOnly = true;
            IFunction function = FunctionManager.getUserDefinedFunction(fName, pTypes);
            if (function != null) {
                if (function.isSQLFunction()) {
                    ReplaceSQLFunction.replaceFunctionWithAst(environment, fNode, (IUDSQLFunction)function);
                    continue;
                }
                if (environment.isBigSQL()) {
                    isDbOnly = true;
                } else if (!function.isDbFunction()) {
                    isDbOnly = false;
                }
                resultType = function.getResultDataType(pTypes);
            }
            fNode.setDBOnly(isDbOnly);
            fNode.setDataType(resultType);
            fNode.setFunction(function);
        }
    }

    public static SQLFid makeFid(IPlanningEnvironment environment, boolean outerRef, SQLQueryItemList itemList, int fieldNo) {
        SQLQueryItem queryItem = (SQLQueryItem)itemList.get(fieldNo);
        queryItem.setReferenced(true);
        queryItem.setIsParameter(outerRef);
        SQLFid fid = outerRef ? (SQLFid)environment.getNodeFactory().createNode(301082) : (SQLFid)environment.getNodeFactory().createNode(301032);
        fid.setName(queryItem.getName());
        fid.setDataType(queryItem.getDataType());
        fid.setContextNo(itemList.getContextNo());
        fid.setSourceNo(queryItem.getSourceNo());
        fid.setColumnNo(queryItem.getColumnNo());
        fid.setVirtualColumnNo(fieldNo);
        fid.setIsNullable(queryItem.isNullable());
        fid.setIsUnique(queryItem.isUnique());
        return fid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getMetaData(IPlanningEnvironment environment, IXQEQueryNode node, IDataSource dataSource, String sqlText) {
        Object executionEnv = environment.getExecutionEnvironment();
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(executionEnv, dataSource);
        AbstractConnection connection = (AbstractConnection)pooledConnection.getConnection();
        executionEnv.registerDataSourceCollationInformation(connection.getDatabaseCollationSequence(), connection.getConnectionCollationSequence());
        SQLQueryItemList qItems = null;
        try {
            qItems = connection.getMetaData((IExecutionEnvironment)executionEnv, pooledConnection, sqlText);
            if (qItems != null) {
                node.setPropertyValue(PROP_OBJECT_QUERYITEMS, qItems);
                node.setPropertyValue(PROP_OBJECT_DATASOURCE, dataSource);
                node.setPropertyValue("describedQueryItems", qItems.copy());
            }
        }
        finally {
            pooledConnection.returnConnection();
        }
        return qItems != null;
    }

    public static SQLQueryItemList makeQueryItems(List<IMetadata> mdObjects) {
        return SQLBinderUtil.makeQueryItems(mdObjects, null, null);
    }

    public static SQLQueryItemList makeQueryItems(List<IMetadata> mdObjects, String schemaName, String tableName) {
        int count = 0;
        for (int i = 0; i < mdObjects.size(); ++i) {
            IQueryItem qItem;
            if (!(mdObjects.get(i) instanceof IQueryItem) || (qItem = (IQueryItem)mdObjects.get(i)).getUniqueName() == null) continue;
            ++count;
        }
        SQLQueryItemList queryItems = new SQLQueryItemList(count);
        int columnNo = 0;
        for (int i = 0; i < mdObjects.size(); ++i) {
            IQueryItem qItem;
            if (!(mdObjects.get(i) instanceof IQueryItem) || (qItem = (IQueryItem)mdObjects.get(i)).getUniqueName() == null) continue;
            SQLQueryItem itemDesc = new SQLQueryItem();
            itemDesc.setSourceNo(0);
            itemDesc.setColumnNo(columnNo++);
            itemDesc.setSchemaName(schemaName);
            itemDesc.setTableName(tableName);
            itemDesc.setBaseTableName(tableName);
            itemDesc.setBaseColumnName(qItem.getUniqueName());
            itemDesc.setName(qItem.getUniqueName());
            itemDesc.setDataType(qItem.getDataType());
            itemDesc.setNullable(qItem.isNullable());
            queryItems.add(itemDesc);
        }
        return queryItems;
    }

    public static boolean compareIdentifiers(String s1, String s2, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return s1.equals(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean determineCaseSensitivity(IDataSourceCapabilities capabilities) {
        return capabilities.isSupported("supports.mixedCaseIdentifiers") || capabilities.isSupported("supports.mixedCaseQuotedIdentifiers") && capabilities.getIdentifierQuoteString() != null;
    }

    public static RowType makeRowTypeFromQueryItems(SQLQueryItemList queryItemList) {
        RowType rowType = DataTypeFactory.getRowType();
        for (SQLQueryItem queryItem : queryItemList) {
            rowType.addField(queryItem.getName(), queryItem.getDataType());
        }
        return rowType;
    }

    public static IDataSource findOrCreateDataSource(IPlanningEnvironment planningEnv, SQLIdentifier identifier) {
        String modelDatasourceName = identifier.getModelDatasourceName();
        String databaseName = identifier.getDatabaseName();
        String catalogName = identifier.getCatalogName();
        String schemaName = identifier.getSchemaName();
        return SQLBinderUtil.findOrCreateDataSource(planningEnv, modelDatasourceName, databaseName, catalogName, schemaName);
    }

    public static IDataSource findOrCreateDataSource(IPlanningEnvironment planningEnv, String databaseName, String catalogName, String schemaName) {
        return SQLBinderUtil.findOrCreateDataSource(planningEnv, null, databaseName, catalogName, schemaName, null);
    }

    public static IDataSource findOrCreateDataSource(IPlanningEnvironment planningEnv, String modelDatasourceName, String databaseName, String catalogName, String schemaName) {
        return SQLBinderUtil.findOrCreateDataSource(planningEnv, modelDatasourceName, databaseName, catalogName, schemaName, null);
    }

    public static void expandDataSourceCMDataSourceNameWithMacro(IPlanningEnvironment planningEnv, IDataSource datasource) {
        if (datasource == null) {
            return;
        }
        if (!MacroExpander.isMacro(datasource.getCMDataSourceName())) {
            return;
        }
        MacroExpander expander = new MacroExpander();
        String cmDataSourceName = expander.expand(null, planningEnv, datasource.getCMDataSourceName());
        datasource.setCMDataSourceName(cmDataSourceName);
    }

    public static IDataSource resolveDataSource(IExecutionEnvironment execEnv, IDataSource dataSource, String modelDatasourceName, String databaseName, String subType) {
        Map<String, Object> metadataProps = MapCast.uncheckedCast(new Flat3Map(dataSource.getMetadataProperties()));
        metadataProps.put("subType", subType);
        return execEnv.getOrAddDataSource(databaseName, databaseName, null, metadataProps);
    }

    public static IDataSource findOrCreateDataSource(IPlanningEnvironment planningEnv, String modelDatasourceName, String databaseName, String catalogName, String schemaName, String cmName) {
        return SQLBinderUtil.findOrCreateDataSource(planningEnv, modelDatasourceName, databaseName, catalogName, schemaName, cmName, true);
    }

    public static IDataSource findOrCreateDataSource(IPlanningEnvironment planningEnv, String modelDatasourceName, String databaseName, String catalogName, String schemaName, String cmName, boolean allowPartialMatch) {
        IDataSource partialMatch = null;
        Object execEnv = planningEnv.getExecutionEnvironment();
        IDataSource dsByModelName = execEnv.getDataSourceByModelNameNoThrow(modelDatasourceName);
        SQLBinderUtil.expandDataSourceCMDataSourceNameWithMacro(planningEnv, dsByModelName);
        for (IDataSource ds : execEnv.getDataSources()) {
            Map<String, Object> metaProps = ds.getMetadataProperties();
            if (null == ds.getName() || !ds.getName().equals(modelDatasourceName) || null == ds.getCMDataSourceName() || !ds.getCMDataSourceName().equals(databaseName)) continue;
            if (null != catalogName && !catalogName.equals(metaProps.get("catalog"))) {
                partialMatch = ds;
                continue;
            }
            if (null != schemaName && !schemaName.equals(metaProps.get("schema"))) {
                partialMatch = ds;
                continue;
            }
            return ds;
        }
        if (null != partialMatch && allowPartialMatch) {
            return partialMatch;
        }
        String cmDataSourceName = cmName;
        if (cmDataSourceName == null) {
            cmDataSourceName = databaseName;
        }
        Map<String, Object> metadataProps = MapCast.uncheckedCast(new Flat3Map());
        metadataProps.put(PROP_CM_DATA_SOURCE, cmDataSourceName);
        metadataProps.put("name", databaseName);
        metadataProps.put("queryType", "relational");
        if (null != schemaName) {
            metadataProps.put("schema", schemaName);
        }
        if (null != catalogName) {
            metadataProps.put("catalog", catalogName);
        }
        return execEnv.getOrAddDataSource(databaseName, cmDataSourceName, null, metadataProps);
    }

    public static IDataSource getDataSource(IExecutionEnvironment executionEnv, IXQEQueryNode node) {
        Collection<IDataSource> dsList = ((SQLQueryNode)node).getDataSourceList(new ArrayList<IDataSource>());
        if (dsList.size() == 0) {
            dsList = executionEnv.getDataSources();
        }
        return dsList.iterator().next();
    }

    public static IDataSource getDatasource(IPlanningEnvironment planningEnv, SQLRelation node) {
        V5SqlQuery sqlQuery;
        IDataSource dataSource = null;
        if (node.getDataSource() != null) {
            return node.getDataSource();
        }
        String databaseName = node.getDatabaseName();
        String catalogName = node.getCatalogName();
        String schemaName = node.getSchemaName();
        if (databaseName == null && (sqlQuery = (V5SqlQuery)node.getAncestorOfType(101016)) != null) {
            databaseName = (String)sqlQuery.getPropertyValue(PROP_OBJECT_DATASOURCE);
        }
        if (databaseName == null) {
            Collection<IDataSource> dataSources = planningEnv.getExecutionEnvironment().getDataSources();
            HashSet<String> cmDsList = new HashSet<String>();
            for (IDataSource ds : dataSources) {
                cmDsList.add(ds.getCMDataSourceName());
            }
            if (cmDsList.size() > 1) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnqualifiedNativeSQL);
            }
            dataSource = dataSources.iterator().next();
        } else {
            dataSource = SQLBinderUtil.findOrCreateDataSource(planningEnv, null, databaseName, catalogName, schemaName);
            if (dataSource == null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_DataSourceNotFound, databaseName);
            }
        }
        return dataSource;
    }

    public static SQLQueryItemList getQueryItemList(SQLQueryNode node) {
        SQLQueryItemList queryItems;
        SQLQueryItemList result = queryItems = ((SQLQueryNode)node.getChild(0)).getQueryItemList();
        boolean addQueryItems = false;
        for (IXQEQueryNode parent = node; parent != null && parent.getType() != 301022; parent = parent.getParent()) {
            if (parent.getType() == 301059) {
                addQueryItems = true;
                queryItems.setContextNo(parent.getContextNo());
            }
            if (parent.getType() != 301004) continue;
            SQLQueryBlock qBlock = (SQLQueryBlock)parent;
            if (addQueryItems) {
                SQLQueryItemList qItemList = ((SQLQueryNode)qBlock.getChild(0)).getQueryItemList();
                queryItems.setParent(qItemList);
                queryItems = qItemList;
                addQueryItems = false;
            }
            if (qBlock.isLateralDerivedTable()) {
                IXQEQueryNode pNode = qBlock.getParent();
                for (int i = 0; i < pNode.getPositionOfChild(qBlock); ++i) {
                    SQLQueryItemList qItemList = ((SQLQueryNode)pNode.getChild(i)).getQueryItemList();
                    queryItems.setParent(qItemList);
                    queryItems = qItemList;
                }
                continue;
            }
            if (qBlock.isDerivedTable()) break;
        }
        return result;
    }

    public static Collection<IDataSource> getDataSources(IRequestEnvironment requestEnv, IXQEQueryNode node) {
        Collection<IDataSource> dataSources = new HashSet<IDataSource>();
        V5SqlQuery sqlQuery = (V5SqlQuery)node.getAncestorOfType(101016);
        if (sqlQuery != null) {
            String databaseName = (String)sqlQuery.getPropertyValue(PROP_OBJECT_DATASOURCE);
            if (databaseName != null) {
                IXQEQueryNode[] dataSource = requestEnv.getExecutionEnvironment().getDataSource(databaseName);
                if (dataSource == null) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_DataSourceNotFound, databaseName);
                }
                dataSources.add((IDataSource)dataSource);
            }
            if (dataSources.isEmpty() && (dataSources = requestEnv.getExecutionEnvironment().getDataSources()).size() != 1) {
                dataSources = new HashSet();
                for (IXQEQueryNode qnode : sqlQuery.getDescendantsOfType(301004, false)) {
                    dataSources.add(((SQLQueryNode)qnode).getDataSource());
                }
            }
        } else {
            V5QuerySet querySet;
            for (IXQEQueryNode parent = node.getParent(); parent != null && (dataSources == null || dataSources.isEmpty()); parent = parent.getParent()) {
                SQLQueryBlock ancestorQBlock = (SQLQueryBlock)parent.getFirstChildByType(301004);
                if (ancestorQBlock == null) continue;
                dataSources = ancestorQBlock.getDataSourceList();
            }
            if ((dataSources == null || dataSources.isEmpty()) && (querySet = (V5QuerySet)node.getAncestorOfType(101002)) != null) {
                dataSources = requestEnv.getExecutionEnvironment().getDataSources();
            }
        }
        return dataSources;
    }
}

