/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.binding;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class SQLQueryItem
extends ColumnInfo {
    private static final long serialVersionUID = 1L;
    public static final String STRING_PROPERTY_CATALOG_NAME = "catalogName";
    public static final String STRING_PROPERTY_SCHEMA_NAME = "schemaName";
    public static final String STRING_PROPERTY_TABLE_NAME = "tableName";
    public static final String STRING_PROPERTY_BASE_TABLE_NAME = "baseTableName";
    public static final String STRING_PROPERTY_BASE_COLUMN_NAME = "baseColumnName";
    public static final String STRING_PROPERTY_SOURCE_NO = "sourceNo";
    public static final String STRING_PROPERTY_COLUMN_NO = "columnNo";
    public static final String STRING_PROPERTY_V_COLUMN_NO = "vColumnNo";
    public static final String STRING_PROPERTY_COLLATION_NAME = "collationName";
    public static final String STRING_PROPERTY_COLLATION_WEIGHT = "collationWeight";
    public static final String STRING_PROPERTY_ICU_EQUIVALENT = "icuEquivalent";
    public static final String STRING_PROPERTY_MODEL_REFERENCE = "modelReference";
    public static final String STRING_PROPERTY_IS_CASE_SENSITIVE = "isCaseSensitive";
    public static final String STRING_PROPERTY_IS_REFERENCED = "isReferenced";
    public static final String STRING_PROPERTY_IS_PARAMETER = "isParameter";
    public static final String STRING_PROPERTY_ATTRIBUTES = "attributes";
    public static final String STRING_PROPERTY_ADJUST_DATA_TYPE_FROM_RESULT_SET = "adjustDataTypeFromResultSet";
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String baseTableName;
    private String baseColumnName;
    private int sourceNo;
    private int columnNo;
    private int vColumnNo = -1;
    private String collationName;
    private int collationWeight;
    private String icuEquivalent;
    private boolean isCaseSensitive = false;
    private IMetadata mModelReference;
    private boolean isReferenced;
    private boolean isParameter;
    private SQLQueryItemList attributes;
    private boolean mAdjustDataTypeFromResultSet = false;

    public IMetadata getModelReference() {
        return this.mModelReference;
    }

    public void setModelReference(IMetadata val) {
        this.mModelReference = val;
    }

    public SQLQueryItem() {
    }

    public SQLQueryItem(String theName, IDataType theDataType) {
        this.name = theName;
        this.dataType = theDataType;
    }

    public SQLQueryItem(String theName, IDataType theDataType, int theColumnNo) {
        this.name = theName;
        this.dataType = theDataType;
        this.columnNo = theColumnNo;
    }

    public SQLQueryItem(IDataType theDataType, int theColumnNo) {
        this.dataType = theDataType;
        this.columnNo = theColumnNo;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String theCatalogName) {
        this.catalogName = theCatalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String theSchemaName) {
        this.schemaName = theSchemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String theTableName) {
        this.tableName = theTableName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String theTableName) {
        this.baseTableName = theTableName;
    }

    public String getBaseColumnName() {
        return this.baseColumnName;
    }

    public void setBaseColumnName(String theBaseColumnName) {
        this.baseColumnName = theBaseColumnName;
    }

    public String getQualifiedName() {
        StringBuilder sBuilder = new StringBuilder();
        if (this.catalogName != null) {
            sBuilder.append(this.catalogName);
            sBuilder.append(".");
        }
        if (this.schemaName != null) {
            sBuilder.append(this.schemaName);
            sBuilder.append(".");
        }
        if (this.tableName != null) {
            sBuilder.append(this.tableName);
            sBuilder.append(".");
        }
        sBuilder.append(this.name);
        return sBuilder.toString();
    }

    public String getParameterName() {
        return String.format("__P_%s", this.name);
    }

    public int getSourceNo() {
        return this.sourceNo;
    }

    public void setSourceNo(int theSourceNo) {
        this.sourceNo = theSourceNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public void setColumnNo(int theColumnNo) {
        this.columnNo = theColumnNo;
    }

    public int getVirtualColumnNo() {
        return this.vColumnNo;
    }

    public void setVirtualColumnNo(int theVirtualColumnNo) {
        this.vColumnNo = theVirtualColumnNo;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String aCollationName) {
        this.collationName = aCollationName;
    }

    public int getCollationWeight() {
        return this.collationWeight;
    }

    public void setCollationWeight(int aCollationWeight) {
        this.collationWeight = aCollationWeight;
    }

    public String getIcuEquivalent() {
        return this.icuEquivalent;
    }

    public void setIcuEquivalent(String icuEquiv) {
        this.icuEquivalent = icuEquiv;
    }

    @Override
    public SQLQueryItem copy() {
        SQLQueryItem qItem = new SQLQueryItem();
        qItem.setSourceNo(this.getSourceNo());
        qItem.setColumnNo(this.getColumnNo());
        qItem.setSchemaName(this.getSchemaName());
        qItem.setTableName(this.getTableName());
        qItem.setBaseTableName(this.getBaseTableName());
        qItem.setBaseColumnName(this.getBaseColumnName());
        qItem.setName(this.getName());
        qItem.setDataType(this.getDataType());
        qItem.setAdjustDataTypeFromResultSet(this.getAdjustDataTypeFromResultSet());
        qItem.setNullable(this.isNullable());
        qItem.setCollationName(this.getCollationName());
        qItem.setCollationWeight(this.getCollationWeight());
        qItem.setModelReference(this.getModelReference());
        qItem.setReferenced(this.isReferenced());
        qItem.setIsParameter(this.isParameter());
        qItem.setAttributeList(this.getAttributeList());
        return qItem;
    }

    public void setCaseSensitivity(boolean isCaseSensitiveInput) {
        this.isCaseSensitive = isCaseSensitiveInput;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }

    public void setReferenced(boolean referenced) {
        this.isReferenced = referenced;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setIsParameter(boolean parameter) {
        this.isParameter |= parameter;
    }

    public SQLQueryItemList getAttributeList() {
        return this.attributes;
    }

    public void setAttributeList(SQLQueryItemList qItems) {
        this.attributes = qItems;
    }

    public boolean getAdjustDataTypeFromResultSet() {
        return this.mAdjustDataTypeFromResultSet;
    }

    public void setAdjustDataTypeFromResultSet(boolean val) {
        this.mAdjustDataTypeFromResultSet = val;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        if (this.catalogName != null) {
            ctx.property(STRING_PROPERTY_CATALOG_NAME, this.catalogName);
        }
        if (this.schemaName != null) {
            ctx.property(STRING_PROPERTY_SCHEMA_NAME, this.schemaName);
        }
        if (this.tableName != null) {
            ctx.property(STRING_PROPERTY_TABLE_NAME, this.tableName);
        }
        if (this.baseTableName != null) {
            ctx.property(STRING_PROPERTY_BASE_TABLE_NAME, this.baseTableName);
        }
        ctx.property(STRING_PROPERTY_SOURCE_NO, this.sourceNo);
        ctx.property(STRING_PROPERTY_COLUMN_NO, this.columnNo);
        ctx.property(STRING_PROPERTY_V_COLUMN_NO, this.vColumnNo);
        if (this.collationName != null) {
            ctx.property(STRING_PROPERTY_COLLATION_NAME, this.collationName);
        }
        ctx.property(STRING_PROPERTY_COLLATION_WEIGHT, this.collationWeight);
        if (this.icuEquivalent != null) {
            ctx.property(STRING_PROPERTY_ICU_EQUIVALENT, this.icuEquivalent);
        }
        ctx.property(STRING_PROPERTY_IS_CASE_SENSITIVE, this.isCaseSensitive);
        ctx.property(STRING_PROPERTY_MODEL_REFERENCE, this.mModelReference);
        ctx.property(STRING_PROPERTY_IS_REFERENCED, this.isReferenced);
        ctx.property(STRING_PROPERTY_IS_PARAMETER, this.isParameter);
        ctx.property(STRING_PROPERTY_ADJUST_DATA_TYPE_FROM_RESULT_SET, this.mAdjustDataTypeFromResultSet);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        ctx.elementProperty(STRING_PROPERTY_ATTRIBUTES, this.attributes);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String name = att.getName();
        if (name.equals(STRING_PROPERTY_CATALOG_NAME)) {
            Object val = ctx.attributeValue(att);
            this.catalogName = (String)val;
        } else if (name.equals(STRING_PROPERTY_SCHEMA_NAME)) {
            Object val = ctx.attributeValue(att);
            this.schemaName = (String)val;
        } else if (name.equals(STRING_PROPERTY_TABLE_NAME)) {
            Object val = ctx.attributeValue(att);
            this.tableName = (String)val;
        } else if (name.equals(STRING_PROPERTY_BASE_TABLE_NAME)) {
            Object val = ctx.attributeValue(att);
            this.baseTableName = (String)val;
        } else if (name.equals(STRING_PROPERTY_BASE_COLUMN_NAME)) {
            Object val = ctx.attributeValue(att);
            this.baseColumnName = (String)val;
        } else if (name.equals(STRING_PROPERTY_SOURCE_NO)) {
            Object val = ctx.attributeValue(att);
            this.sourceNo = (Integer)val;
        } else if (name.equals(STRING_PROPERTY_COLUMN_NO)) {
            Object val = ctx.attributeValue(att);
            this.columnNo = (Integer)val;
        } else if (name.equals(STRING_PROPERTY_V_COLUMN_NO)) {
            Object val = ctx.attributeValue(att);
            this.vColumnNo = (Integer)val;
        } else if (name.equals(STRING_PROPERTY_COLLATION_NAME)) {
            Object val = ctx.attributeValue(att);
            this.collationName = (String)val;
        } else if (name.equals(STRING_PROPERTY_COLLATION_WEIGHT)) {
            Object val = ctx.attributeValue(att);
            this.collationWeight = (Integer)val;
        } else if (name.equals(STRING_PROPERTY_ICU_EQUIVALENT)) {
            Object val = ctx.attributeValue(att);
            this.icuEquivalent = (String)val;
        } else if (name.equals(STRING_PROPERTY_IS_CASE_SENSITIVE)) {
            Object val = ctx.attributeValue(att);
            this.isCaseSensitive = (Boolean)val;
        } else if (name.equals(STRING_PROPERTY_IS_REFERENCED)) {
            Object val = ctx.attributeValue(att);
            this.isReferenced = (Boolean)val;
        } else if (name.equals(STRING_PROPERTY_IS_PARAMETER)) {
            Object val = ctx.attributeValue(att);
            this.isParameter = (Boolean)val;
        } else if (name.equals(STRING_PROPERTY_ADJUST_DATA_TYPE_FROM_RESULT_SET)) {
            Object val = ctx.attributeValue(att);
            this.mAdjustDataTypeFromResultSet = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, node);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(STRING_PROPERTY_ATTRIBUTES)) {
            Object val = ctx.elementValue(node);
            this.attributes = (SQLQueryItemList)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

