/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.decoration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.SQLValueDecoration;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5GroupFooter;
import com.cognos.xqe.ast.v5.result.V5GroupHeader;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class InitializeGroupedV5ValueSetDecoration
extends RQPTransformation {
    public InitializeGroupedV5ValueSetDecoration() {
        this.mName = "Create grouped V5ValueSet decoration.";
        this.mPassNumbers = new int[]{87};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] groupFooter;
        IXQEQueryNode[] groupHeader;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode rqpSQL = node.getAncestorOfType(801041);
        IXQEQueryNode dataset = node.getAncestorOfType(401005);
        RSAPIEdgeRowset rsapiRowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        node.removeProperty("RSAPIEdgeRowset");
        SQLValueDecoration dNode = (SQLValueDecoration)nodeFactory.createNode(601013);
        dNode.setRSAPIRowsetProperty(rsapiRowset);
        IXQEQueryNode[] groupBody = node.getChildrenOfType(101051);
        if (groupBody != null && groupBody.length > 0) {
            V5GroupBody gb = (V5GroupBody)groupBody[0];
            IXQEQueryNode[] groupBodyDataItemRefs = gb.getChildrenOfTypeOrdered(101015);
            dNode.setGroupBodyDataItemRefs(groupBodyDataItemRefs);
        }
        if ((groupHeader = node.getChildrenOfType(101053)) != null && groupHeader.length > 0) {
            V5GroupHeader gh = (V5GroupHeader)groupHeader[0];
            RSAPIEdgeRowset ghRSAPIRowset = gh.getRSAPIEdgeRowset();
            dNode.setGroupHeaderRSAPIRowsetProperty(ghRSAPIRowset);
            IXQEQueryNode[] groupHeaderDataItemRefs = gh.getChildrenOfTypeOrdered(101015);
            dNode.setGroupHeaderDataItemRefs(groupHeaderDataItemRefs);
        }
        if ((groupFooter = node.getChildrenOfType(101052)) != null && groupFooter.length > 0) {
            V5GroupFooter gf = (V5GroupFooter)groupFooter[0];
            RSAPIEdgeRowset gfRSAPIRowset = (RSAPIEdgeRowset)gf.getPropertyValue("RSAPIEdgeRowset");
            dNode.setGroupFooterRSAPIRowsetProperty(gfRSAPIRowset);
            IXQEQueryNode[] groupFooterDataItemRefs = gf.getChildrenOfTypeOrdered(101015);
            dNode.setGroupFooterDataItemRefs(groupFooterDataItemRefs);
        }
        if (null == dataset) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "InitializeGroupedV5ValueSetDecoration requires dataset");
        }
        IXQEQueryNode[] existingDecorationNode = dataset.getChildrenOfType(601013);
        if (existingDecorationNode != null && existingDecorationNode.length > 0) {
            existingDecorationNode[0].insertParent(dNode);
        } else {
            rqpSQL.insertParent(dNode);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("refDataItem") == null) {
            this.traceNodeCondition(false, "The V5ValueSet node has no refDataItem property.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Need to create the default decoration for this value set.", trace);
        return true;
    }
}

