/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.regex.Matcher;

public class AddExplicitTypeConversion
extends RQETransformation {
    private static final String SPACE = " ";

    public AddExplicitTypeConversion() {
        this.mName = "Normalize SQLComparison node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301031};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLExpression operand;
        SQLQueryBlock qBlock = ((SQLQueryNode)node).getParentQueryBlock();
        IDataSource dataSource = qBlock.getDataSource();
        SQLLiteral literalNode = (SQLLiteral)node;
        IXQEQueryNode parent = node.getParent();
        IDataType dType = null;
        if (parent.getType() == 301026) {
            SQLExpression leftNode = (SQLExpression)parent.getChild(0);
            SQLExpression rightNode = (SQLExpression)parent.getChild(1);
            dType = leftNode == node ? rightNode.getDataType() : leftNode.getDataType();
        } else if (parent.getType() == 301030) {
            operand = (SQLExpression)parent.getParent().getChild(0);
            dType = operand.getDataType();
        } else if (parent.getType() == 301045) {
            operand = (SQLExpression)parent.getChild(0);
            dType = operand.getDataType();
        } else {
            String dateStr = literalNode.getValue().getString();
            Matcher m = TimestampValue.getPattern().matcher(dateStr);
            if (m.matches()) {
                String[] parts = dateStr.split(SPACE);
                dType = parts.length > 1 ? DataTypeFactory.getTimestampType() : DataTypeFactory.getDateType();
            }
        }
        if (SQLLiteral.isFeatureSupported(dataSource, dType)) {
            literalNode.setDataType(dType);
            literalNode.setValue(literalNode.getValue().getString());
        } else {
            XQENodeFactory factory = environment.getNodeFactory();
            IXQEQueryNode castNode = factory.createNode(301047);
            SQLDataType dTypeNode = (SQLDataType)factory.createNode(301037);
            dTypeNode.setDataType(dType);
            literalNode.insertParent(castNode);
            castNode.addChild(dTypeNode);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = ((SQLQueryNode)node).getParentQueryBlock();
        SQLLiteral literalNode = (SQLLiteral)node;
        boolean bl = status = qBlock != null && qBlock.isForeign();
        if (status) {
            IDataSource dataSource = qBlock.getDataSource();
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            IXQEQueryNode parent = node.getParent();
            boolean bl2 = status = !capabilities.getBooleanValue("supports.implicitTypeConversion") && ((SQLExpression)node).isCharacterLiteral() && (parent.getType() == 301026 || parent.getType() == 301030 && parent.getParent().getType() == 301076 || parent.getType() == 301045 && parent.getChild(0) != node || parent.getType() == 301033 && ((SQLFunction)parent).isBusinessDateFunction());
            if (status) {
                IDataType dType = null;
                if (parent.getType() == 301026) {
                    SQLExpression leftNode = (SQLExpression)parent.getChild(0);
                    SQLExpression rightNode = (SQLExpression)parent.getChild(1);
                    dType = leftNode == node ? rightNode.getDataType() : leftNode.getDataType();
                } else if (parent.getType() == 301030) {
                    SQLExpression operand = (SQLExpression)parent.getParent().getChild(0);
                    dType = operand.getDataType();
                } else if (parent.getType() == 301045) {
                    SQLExpression operand = (SQLExpression)parent.getChild(0);
                    dType = operand.getDataType();
                } else {
                    String dateStr = literalNode.getValue().getString();
                    Matcher m = TimestampValue.getPattern().matcher(dateStr);
                    if (m.matches()) {
                        String[] parts = dateStr.split(SPACE);
                        dType = parts.length > 1 ? DataTypeFactory.getTimestampType() : DataTypeFactory.getDateType();
                    }
                }
                boolean bl3 = status = dType != null && dType.getSubType() == DataSubType.DATETIMETYPE;
                if (status) {
                    boolean bl4 = status = SQLLiteral.isFeatureSupported(dataSource, dType) || SQLCast.isFeatureSupported(capabilities, new IDataType[]{dType, literalNode.getDataType()});
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Explicit type conversion required.", trace);
        } else {
            this.traceQueryCondition(status, "Explicit type conversion is not required.", trace);
        }
        return status;
    }
}

