/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.LinkedList;

public final class AnalyzeForVectorizedQueryExecution
extends RQETransformation {
    private static final String MODULE = "module";
    private static final String VQE_ENABLED = "queryExecution.vectorizedQueryExecution[@enabled]";
    private static final String VQE_FOR_MODULES_ENABLED = "queryExecution.vectorizedQueryExecution.modules[@enabled]";
    private static final String VQE_FOR_PACKAGES_ENABLED = "queryExecution.vectorizedQueryExecution.packages[@enabled]";

    public AnalyzeForVectorizedQueryExecution() {
        this.mName = "Analyze for vectorized query execution.";
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{601013};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        LinkedList<String> list = new LinkedList<String>();
        node.setPropertyValue("vectorizable", ((ISQLQueryNode)node.getChild(0)).isVectorizable(list));
        XQELogger log = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryProcessing", LogLevel.TRACE);
        if (list.size() != 0 && log.isOn(LogLevel.TRACE)) {
            RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
            StringBuilder sb = new StringBuilder();
            sb.append("VQE enabled but query is not vectorizable");
            if (environment.getRequestEnvironment() != null && environment.getRequestEnvironment().getReportName() != null) {
                sb.append(" for report and query: ");
                sb.append(environment.getRequestEnvironment().getReportName());
                sb.append("/");
                if (rsapiDataset != null && rsapiDataset.getRefQueryName() != null) {
                    sb.append(rsapiDataset.getRefQueryName());
                }
            } else if (rsapiDataset != null && rsapiDataset.getRefQueryName() != null) {
                sb.append(" for query: ");
                sb.append(rsapiDataset.getRefQueryName());
            }
            sb.append(". Reason: %1$s");
            log.log(String.format(sb.toString(), SQLQueryNode.getUnsupportedReason(list)));
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        MultiRequestContext mrContext = environment.getMultiRequestContext();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        boolean vqeEnabled = mrContext.fetchBooleanConfiguration(VQE_ENABLED, false);
        boolean vqeForModulesEnabled = mrContext.fetchBooleanConfiguration(VQE_FOR_MODULES_ENABLED, false);
        boolean vqeForPackagesEnabled = mrContext.fetchBooleanConfiguration(VQE_FOR_PACKAGES_ENABLED, false);
        boolean bl = status = node.getChild(0).getType() != 601013 && node.getPropertyValue("vectorizable") == null;
        if (status) {
            Boolean vectorizationGovernor;
            Governors gov;
            V5QuerySet v5QuerySet;
            status = vqeEnabled;
            if (!status && querySet != null) {
                String modelType = querySet.getModelType();
                status = modelType == null || !modelType.equals(MODULE) ? vqeForPackagesEnabled : vqeForModulesEnabled;
            }
            if ((v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002)) != null && (gov = v5QuerySet.getGovernorOfRetrieveDatasetV5Query()) != null && (vectorizationGovernor = gov.getUseVectorizedQueryExecution()) != null) {
                status = vectorizationGovernor;
                XQELogger log = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryProcessing", LogLevel.TRACE);
                if (status) {
                    log.log("Vectorization is enabled via a query hint useVectorizedQueryExecution.");
                } else {
                    log.log("Vectorization is disabled via a query hint useVectorizedQueryExecution.");
                }
            }
        }
        this.traceQueryCondition(true, "No Query Condition", trace);
        return status;
    }
}

