/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class CollapseGroupByAndSort
extends RQETransformation {
    public CollapseGroupByAndSort() {
        this.mName = "Remove SQLGroupBy node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301004) {
            parent.extract();
        }
        SQLSort sortNode = (SQLSort)node.getParent();
        sortNode.setDistinct(true);
        node.detachChildrenExceptFirst();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = (pQueryBlock == null || !pQueryBlock.isForeign()) && CollapseGroupByAndSort.canRemoveSQLGroupBy(node);
        if (status) {
            this.traceQueryCondition(status, "GROUP BY node can be removed.", trace);
        } else {
            this.traceQueryCondition(status, "GROUP BY node cannot be removed.", trace);
        }
        return status;
    }

    private static boolean canRemoveSQLGroupBy(IXQEQueryNode node) {
        boolean status;
        SQLValueList outputList = ((SQLGroupBy)node).getOutputList();
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        int nColumns = outputList.getNumberChildren();
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301004) {
            parent = parent.getParent();
        }
        boolean bl = status = parent.getType() == 301019;
        if (status) {
            boolean bl2 = status = groupByList != null && groupByList.getNumberChildren() == nColumns;
        }
        if (status) {
            boolean bl3 = status = ((ISQLQueryNode)node.getChild(0)).getNumberColumns() == nColumns;
        }
        if (status) {
            SQLSortKeyList sortKeyList = ((SQLSort)parent).getSortKeyList();
            if (sortKeyList.getNumberChildren() == nColumns) {
                for (int i = 0; i < nColumns; ++i) {
                    IXQEQueryNode exprNode = outputList.getChild(i);
                    if (exprNode.getType() != 301032 || ((SQLFid)exprNode).getVirtualColumnNo() != i) {
                        status = false;
                    } else {
                        exprNode = ((SQLSortKey)sortKeyList.getChild(i)).getChild(0);
                        if (exprNode.getType() == 301032 && ((SQLFid)exprNode).getVirtualColumnNo() == i) continue;
                        status = false;
                    }
                    break;
                }
            } else {
                status = false;
            }
        }
        return status;
    }
}

