/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertDateToTimestampInCaseConstruct
extends RQETransformation {
    public ConvertDateToTimestampInCaseConstruct() {
        this.mName = "Convert date to timestamp in a case construct.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301073, 301074};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        if (301073 == node.getType()) {
            this.doUpCastInSimpleCase(node, environment);
        } else {
            this.doUpCastInSearchedCase(node, environment);
        }
    }

    private void doUpCastInSimpleCase(IXQEQueryNode fNode, IPlanningEnvironment environment) {
        IDataType dType;
        SQLValueList sqlValueList = (SQLValueList)fNode.getChild(1);
        for (IXQEQueryNode iChild : sqlValueList.getChildren()) {
            SQLWhen sqlWhen = (SQLWhen)iChild;
            IDataType dType2 = ((IValueExpression)sqlWhen.getChild(1)).getDataType();
            if (91 != dType2.getJDBCType()) continue;
            this.upcastToTimestamp(sqlWhen.getChild(1), environment);
        }
        if (fNode.getNumberChildren() > 2 && 91 == (dType = ((IValueExpression)fNode.getChild(2)).getDataType()).getJDBCType()) {
            this.upcastToTimestamp(fNode.getChild(2), environment);
        }
    }

    private void doUpCastInSearchedCase(IXQEQueryNode fNode, IPlanningEnvironment environment) {
        IDataType dType;
        SQLValueList sqlValueList = (SQLValueList)fNode.getChild(0);
        for (IXQEQueryNode iChild : sqlValueList.getChildren()) {
            SQLWhen sqlWhen = (SQLWhen)iChild;
            IDataType dType2 = ((IValueExpression)sqlWhen.getChild(1)).getDataType();
            if (91 != dType2.getJDBCType()) continue;
            this.upcastToTimestamp(sqlWhen.getChild(1), environment);
        }
        if (fNode.getNumberChildren() > 1 && 91 == (dType = ((IValueExpression)fNode.getChild(1)).getDataType()).getJDBCType()) {
            this.upcastToTimestamp(fNode.getChild(1), environment);
        }
    }

    private void upcastToTimestamp(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode parent = node.getParent();
        if (301047 == node.getType()) {
            ((SQLDataType)node.getChild(1)).setDataType(DataTypeFactory.getTimestampType());
        } else {
            SQLCast castNode = (SQLCast)factory.createNode(301047);
            SQLDataType castType = (SQLDataType)factory.createNode(301037);
            castType.setDataType(DataTypeFactory.getTimestampType());
            parent.exchangeChildNode(node, castNode, false);
            castNode.addChild(node);
            castNode.addChild(castType);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean status = false;
        if (null != qBlock && !qBlock.isForeign()) {
            IDataType[] foundTypes = this.getDataTypes(node);
            boolean bDateFound = false;
            boolean bTimestampFound = false;
            for (int i = 0; i < foundTypes.length; ++i) {
                if (!bDateFound && 91 == foundTypes[i].getJDBCType()) {
                    bDateFound = true;
                }
                if (!bTimestampFound && 93 == foundTypes[i].getJDBCType()) {
                    bTimestampFound = true;
                }
                if (bDateFound && bTimestampFound) break;
            }
            boolean bl = status = bDateFound && bTimestampFound;
        }
        if (status) {
            this.traceQueryCondition(status, "Up cast is needed for the case construct.", trace);
        } else {
            this.traceQueryCondition(status, "Up cast is not needed for the case construct.", trace);
        }
        return status;
    }

    private IDataType[] getDataTypes(IXQEQueryNode fNode) {
        IDataType[] pTypes = null;
        if (301073 == fNode.getType()) {
            SQLValueList vList = (SQLValueList)fNode.getChild(1);
            pTypes = fNode.getNumberChildren() > 2 ? new IDataType[vList.getNumberChildren() + 1] : new IDataType[vList.getNumberChildren()];
            int iCount = 0;
            for (IXQEQueryNode child : vList.getChildren()) {
                pTypes[iCount++] = ((IValueExpression)((SQLWhen)child).getChild(1)).getDataType();
            }
            if (fNode.getNumberChildren() > 2) {
                pTypes[iCount] = ((IValueExpression)fNode.getChild(2)).getDataType();
            }
        } else {
            SQLValueList vList = (SQLValueList)fNode.getChild(0);
            pTypes = fNode.getNumberChildren() > 1 ? new IDataType[vList.getNumberChildren() + 1] : new IDataType[vList.getNumberChildren()];
            int iCount = 0;
            for (IXQEQueryNode child : vList.getChildren()) {
                pTypes[iCount++] = ((IValueExpression)((SQLWhen)child).getChild(1)).getDataType();
            }
            if (fNode.getNumberChildren() > 1) {
                pTypes[iCount] = ((IValueExpression)fNode.getChild(1)).getDataType();
            }
        }
        return pTypes;
    }
}

