/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertDifference
extends RQETransformation {
    public ConvertDifference() {
        this.mName = "Convert DIFFERENCE aggregate.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLAggregate aggrNode = (SQLAggregate)node;
        SQLValueExpression vExprNode = (SQLValueExpression)nodeFactory.createNode(301025);
        vExprNode.setSubType(SQLValueExpression.SubType.SUBTRACT);
        vExprNode.addChild(aggrNode.getChild(0), 0);
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (SQLAggregate.isOlapFeatureSupported(pQueryBlock.getDataSource().getCapabilities(), SQLAggregate.SubType.LAG, aggrNode.getNumberParameters())) {
            SQLAggregate lagNode = (SQLAggregate)nodeFactory.createNode(301034);
            lagNode.setSubType(SQLAggregate.SubType.LAG);
            IXQEQueryNode[] children = node.getChildren();
            node.detachChildren();
            lagNode.addChildren(children, 0);
            IXQEQueryNode[] windows = lagNode.getChildrenOfType(301041);
            SQLWindow window = (SQLWindow)windows[0];
            if (window.getWindowFrameUnits() != null) {
                window.removeProperty("units");
            }
            if (window.getWindowFrameLowerBound() != null) {
                window.removeProperty("lowerBound");
            }
            if (window.getWindowFrameUpperBound() != null) {
                window.removeProperty("upperBound");
            }
            vExprNode.addChild(lagNode, 1);
        } else {
            SQLAggregate maxNode = (SQLAggregate)nodeFactory.createNode(301034);
            maxNode.setSubType(SQLAggregate.SubType.MAX);
            IXQEQueryNode[] children = node.getChildren();
            node.detachChildren();
            maxNode.addChildren(children, 0);
            IXQEQueryNode[] windows = maxNode.getChildrenOfType(301041);
            SQLWindow window = (SQLWindow)windows[0];
            window.setWindowFrameUnits("ROWS");
            window.setWindowFrameLowerBound(-1);
            window.setWindowFrameUpperBound(-1);
            vExprNode.addChild(maxNode, 1);
        }
        node.exchange(vExprNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLAggregate sqlNode = (SQLAggregate)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = null != pQueryBlock && pQueryBlock.isForeign();
        if (status) {
            boolean bl2 = status = sqlNode.getSubType() == SQLAggregate.SubType.DIFFERENCE && !SQLAggregate.isOlapFeatureSupported(pQueryBlock.getDataSource().getCapabilities(), SQLAggregate.SubType.DIFFERENCE, sqlNode.getNumberParameters());
        }
        if (status) {
            status = sqlNode.isConvertible(pQueryBlock.getDataSource().getCapabilities());
        }
        if (status) {
            this.traceQueryCondition(status, "DIFFERENCE aggregate needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "DIFFERENCE aggregate doesn't need to be converted.", trace);
        }
        return status;
    }
}

