/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWhen;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class ConvertNullOrderingInSort
extends RQETransformation {
    public ConvertNullOrderingInSort() {
        this.mName = "Convert Null Ordering Clause.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{301019, 301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        block4: {
            SQLSortKeyList sortKeyListNode;
            SQLValueList valueList;
            IDataSource dataSource;
            XQENodeFactory nodeFactory;
            block3: {
                nodeFactory = environment.getNodeFactory();
                SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
                dataSource = pQueryBlock.getDataSource();
                valueList = pQueryBlock.getOutputList();
                sortKeyListNode = null;
                if (!(node instanceof SQLAggregate)) break block3;
                SQLWindow sqlWindow = (SQLWindow)node.getFirstChildByType(301041);
                sortKeyListNode = (SQLSortKeyList)sqlWindow.getFirstChildByType(301021);
                for (int i = 0; i < sortKeyListNode.getNumberChildren(); ++i) {
                    SQLSortKey sortKey = (SQLSortKey)sortKeyListNode.getChild(i);
                    if (sortKey.getNullOrder() == SQLSortKey.NullOrdering.UNSPECIFIED || sortKey.isNullOrderingSupportedInWindowSpecification(dataSource)) continue;
                    SQLSortKey newSortKey = this.createNewSortKeyForNullOrdering(nodeFactory, sortKey, null);
                    sortKeyListNode.addChild(newSortKey, i);
                    sortKey.setNullOrder(SQLSortKey.NullOrdering.UNSPECIFIED);
                }
                break block4;
            }
            if (!(node instanceof SQLSort)) break block4;
            sortKeyListNode = (SQLSortKeyList)node.getFirstChildByType(301021);
            for (int i = 0; i < sortKeyListNode.getNumberChildren(); ++i) {
                SQLSortKey sortKey = (SQLSortKey)sortKeyListNode.getChild(i);
                if (sortKey.getNullOrder() == SQLSortKey.NullOrdering.UNSPECIFIED || sortKey.isNullOrderingSupported(dataSource)) continue;
                IXQEQueryNode eNode = sortKey.getChild(0);
                if (!dataSource.getCapabilities().getBooleanValue("supports.aliasInOrderByExpression")) {
                    eNode = valueList.getChild(sortKey.getColumnNo());
                }
                SQLSortKey newSortKey = this.createNewSortKeyForNullOrdering(nodeFactory, sortKey, eNode);
                sortKeyListNode.addChild(newSortKey, i);
                sortKey.setNullOrder(SQLSortKey.NullOrdering.UNSPECIFIED);
            }
        }
    }

    private SQLSortKey createNewSortKeyForNullOrdering(IXQENodeFactory nodeFactory, SQLSortKey sortNode, IXQEQueryNode expressionNode) {
        SQLSortKey newSortKey = (SQLSortKey)nodeFactory.createNode(301020);
        SQLSearchedCase searchedCaseNode = (SQLSearchedCase)nodeFactory.createNode(301074);
        SQLValueList valueListNode = (SQLValueList)nodeFactory.createNode(301030);
        SQLWhen whenNode = (SQLWhen)nodeFactory.createNode(301048);
        SQLIsNull isNullNode = (SQLIsNull)nodeFactory.createNode(301024);
        if (expressionNode != null) {
            isNullNode.addChild(nodeFactory.deepCopyNode(expressionNode));
        } else {
            isNullNode.addChild(nodeFactory.deepCopyNode(sortNode.getChild(0)));
        }
        whenNode.addChild(isNullNode);
        valueListNode.addChild(whenNode);
        searchedCaseNode.addChild(valueListNode);
        SQLLiteral literalOne = (SQLLiteral)nodeFactory.createNode(301031);
        literalOne.setDataType(IntegerType.INTEGERTYPE);
        literalOne.setValue("1");
        SQLLiteral literalZero = (SQLLiteral)nodeFactory.createNode(301031);
        literalZero.setDataType(IntegerType.INTEGERTYPE);
        literalZero.setValue("0");
        if (sortNode.getNullOrder() == SQLSortKey.NullOrdering.NULLS_FIRST) {
            whenNode.addChild(literalZero, 1);
            searchedCaseNode.addChild(literalOne, 1);
        } else {
            whenNode.addChild(literalOne, 1);
            searchedCaseNode.addChild(literalZero, 1);
        }
        newSortKey.addChild(searchedCaseNode);
        newSortKey.setGenerated(true);
        return newSortKey;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (pQueryBlock != null && pQueryBlock.isForeign()) {
            IDataSource dataSource = pQueryBlock.getDataSource();
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            if (dataSource.isRelational() && capabilities.getBooleanValue("supports.expressionsInOrderBy")) {
                if (node instanceof SQLSort) {
                    SQLSortKeyList sortKeyListNode = (SQLSortKeyList)node.getFirstChildByType(301021);
                    status = sortKeyListNode.isSupported(dataSource) && sortKeyListNode.containNotSupportedNullOrdering(dataSource);
                } else if (node instanceof SQLAggregate && ((SQLAggregate)node).isWindowedAggregate()) {
                    SQLWindow windowNode = (SQLWindow)node.getFirstChildByType(301041);
                    SQLSortKeyList sortKeyListNode = (SQLSortKeyList)windowNode.getFirstChildByType(301021);
                    boolean bl = status = sortKeyListNode != null && sortKeyListNode.containNotSupportedNullOrderingInWindowSpecification(dataSource);
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Null Ordering Clause needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "Null Ordering Clause doesn't need to be converted.", trace);
        }
        return status;
    }
}

