/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class ConvertSQLDistinctToGroupBy
extends RQETransformation {
    private static final String PERFORMANCE_CONVERT_DISTINCT_TO_GROUPBY = "performance.convertDistinctToGroupBy";

    public ConvertSQLDistinctToGroupBy() {
        this.mName = "Convert the SQLDistinct node to a SQLGroupBy node.";
        this.mPassNumbers = new int[]{0};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301008};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode groupByNode = nodeFactory.createNode(301010);
        IXQEQueryNode groupByList = nodeFactory.createNode(301029);
        IXQEQueryNode projectNode = node.getChild(0);
        node.extract();
        projectNode.exchange(groupByNode, true);
        groupByNode.addChild(groupByList);
        SQLValueList valueList = ((SQLGroupBy)groupByNode).getOutputList();
        for (int i = 0; i < valueList.getNumberChildren(); ++i) {
            IXQEQueryNode child = valueList.getChild(i);
            boolean addToGroupByList = true;
            for (int j = 0; j < groupByList.getNumberChildren() && addToGroupByList; ++j) {
                addToGroupByList = !child.isSameExpression(groupByList.getChild(j), false);
            }
            if (!addToGroupByList) continue;
            IXQEQueryNode copyChild = nodeFactory.deepCopyNode(child);
            groupByList.addChild(copyChild);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataSource dataSource;
        IDataSourceCapabilities capabilities;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IXQEQueryNode child = node.getChild(0);
        boolean status = false;
        if (qBlock != null && qBlock.isForeign() && child.getType() == 301015 && (capabilities = (dataSource = qBlock.getDataSource()).getCapabilities()).isSupported(PERFORMANCE_CONVERT_DISTINCT_TO_GROUPBY) && SQLGroupBy.isFeatureSupported(capabilities)) {
            SQLValueList valueList = ((SQLProject)child).getOutputList();
            List<IXQEQueryNode> aggrs = valueList.getDescendantsOfTypeOrdered(301034, false);
            if (aggrs.size() == 0) {
                status = true;
            }
            if (status && !capabilities.isSupported("supports.expressionsInGroupBy")) {
                for (int i = 0; i < valueList.getNumberChildren() && status; ++i) {
                    if (valueList.getChild(i).getType() == 301032) continue;
                    status = false;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Distinct can be converted to Group By.", trace);
        } else {
            this.traceQueryCondition(status, "Distinct can not be converted to Group By.", trace);
        }
        return status;
    }
}

