/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public class CreateAliasesForGroupBy
extends RQETransformation {
    private static final String TRANSFORMATION_HAS_BEEN_DONE = "CreateAliasesForGroupBy";

    public CreateAliasesForGroupBy() {
        this.mName = "Convert group by name to group by alias";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLValueList projList = ((SQLGroupBy)node).getValueList();
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        List<SQLAlias> aliasList = projList.getAliasList();
        for (int i = 0; i < groupByList.getNumberChildren(); ++i) {
            SQLQueryNode grpbyNode = (SQLQueryNode)groupByList.getChild(i);
            if (grpbyNode.getType() != 301032) continue;
            for (int j = 0; j < projList.getNumberChildren(); ++j) {
                IXQEQueryNode projNode = projList.getChild(j);
                if (projNode.getType() != 301032 || !grpbyNode.isSameExpression(projNode, false)) continue;
                SQLAlias alias = aliasList.get(j);
                if (alias == null) {
                    alias = (SQLAlias)nodeFactory.createNode(301028);
                    alias.setName(((SQLFid)projNode).getName());
                    aliasList.set(j, alias);
                }
                ((SQLFid)grpbyNode).setName(alias.getName());
                ((SQLFid)grpbyNode).setTableName(null);
                ((SQLFid)grpbyNode).setSchemaName(null);
                ((SQLFid)grpbyNode).setCatalogName(null);
            }
        }
        node.setPropertyValue(TRANSFORMATION_HAS_BEEN_DONE, "");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        status = dataSource != null && dataSource.getCapabilities().isSupported("supports.groupByAlias");
        if (status &= node.getPropertyValue(TRANSFORMATION_HAS_BEEN_DONE) == null) {
            status = false;
            SQLValueList projList = ((SQLGroupBy)node).getValueList();
            List<SQLAlias> aliasList = projList.getAliasList();
            SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
            status = aliasList != null && groupByList != null && groupByList.getNumberChildren() != 0;
            for (int i = 0; i < projList.getNumberChildren() && status; ++i) {
                IXQEQueryNode exprNode = projList.getChild(i);
                if (exprNode.getType() != 301032) continue;
                String table = ((SQLFid)exprNode).getTableName();
                SQLAlias alias = aliasList.get(i);
                if (alias == null || table == null || !alias.getName().equals(table)) continue;
                status = true;
                break;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Group by on alias requires.", trace);
        } else {
            this.traceQueryCondition(status, "Group by on alias does not require.", trace);
        }
        return status;
    }
}

