/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.qep.QEPAbstractPlan;
import com.cognos.xqe.ast.qep.QEPJoin;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.CreateJoinPlan;
import com.cognos.xqe.transformation.relational.optimization.util.Planner;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class CreateCrossJoinPlan
extends RQETransformation {
    public CreateCrossJoinPlan() {
        this.mName = "Create cross-join plan.";
        this.mPassNumbers = new int[]{1};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301014, 301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        Planner planner = new Planner(environment);
        IXQEQueryNode[] children = node.getChildren();
        QEPJoin joinPlan = (QEPJoin)planner.createPlan(901012);
        joinPlan.addChild(children[0].detach());
        joinPlan.setNumberColumns(((ISQLQueryNode)children[0]).getNumberColumns());
        for (int i = 1; i < children.length; ++i) {
            if (joinPlan.isLateralJoin()) {
                QEPJoin tmpPlan = joinPlan;
                joinPlan = (QEPJoin)planner.createPlan(901012);
                joinPlan.addChild(tmpPlan);
            }
            ISQLQueryNode child = (ISQLQueryNode)children[i].detach();
            joinPlan.addChild(child);
            if (child.isLateralDerivedTable()) {
                joinPlan.setLateral(true);
            } else {
                QEPAbstractPlan storePlan = planner.createPlan(901010);
                joinPlan.getChild(joinPlan.getNumberChildren() - 1).insertParent(storePlan);
            }
            joinPlan.setNumberColumns(joinPlan.getNumberColumns() + child.getNumberColumns());
        }
        CreateJoinPlan.injectParameterMappers(planner, CollectionCast.downcast(joinPlan.getDescendantsOfTypesOrdered(CreateJoinPlan.JOIN_TYPES, true), IXQEQueryNode.class, QEPJoin.class));
        node.exchange(joinPlan, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = !qBlock.isForeign() && (node.getType() == 301011 && ((SQLJoin)node).getJoinType() == SQLJoin.SubType.CROSS || qBlock.getNumberOfFactors() == 0);
        if (status) {
            this.traceQueryCondition(status, "Query block is a SQLProduct query block.", trace);
        } else {
            this.traceQueryCondition(status, "Query block is not a SQLProduct query block.", trace);
        }
        return status;
    }
}

