/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.qep.QEPJoin;
import com.cognos.xqe.ast.qep.QEPMergeJoin;
import com.cognos.xqe.ast.qep.QEPParameterMapper;
import com.cognos.xqe.ast.qep.QEPScan;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.optimization.util.JoinPlanner;
import com.cognos.xqe.transformation.relational.optimization.util.Planner;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Iterator;
import java.util.List;

public class CreateJoinPlan
extends RQETransformation {
    public static final int[] JOIN_TYPES = new int[]{901013, 901014, 901015, 901022, 901012};

    public CreateJoinPlan() {
        this.mName = "Create join plan.";
        this.mPassNumbers = new int[]{0};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301014, 301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        int nSources;
        XQENodeFactory factory = environment.getNodeFactory();
        JoinPlanner joinPlanner = new JoinPlanner(environment);
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        QEPJoin joinPlan = joinPlanner.createJoinPlan(qBlock, node, nSources = node.getNumberChildren());
        if (joinPlan == null) {
            throw new UnsupportedOperationException();
        }
        List<QEPScan> scans = CollectionCast.downcast(joinPlan.getDescendantsOfTypeOrdered(901011, false), IXQEQueryNode.class, QEPScan.class);
        List<QEPJoin> plans = CollectionCast.downcast(joinPlan.getDescendantsOfTypesOrdered(JOIN_TYPES, true), IXQEQueryNode.class, QEPJoin.class);
        node.exchange(joinPlan);
        int[] joinOrder = new int[nSources];
        int[] nColumns = new int[nSources];
        IXQEQueryNode[] children = node.getChildren();
        node.detachChildren();
        int i = 0;
        for (QEPScan qEPScan : scans) {
            int sourceNo = qEPScan.getSourceNo();
            SQLQueryNode child = (SQLQueryNode)children[sourceNo];
            qEPScan.exchange(child);
            joinOrder[sourceNo] = i;
            nColumns[i] = child.getNumberColumns();
            if (i > 0) {
                int n = i;
                nColumns[n] = nColumns[n] + nColumns[i - 1];
            }
            ++i;
        }
        List<SQLFid> fidList = qBlock.getFieldIdentifiers();
        for (SQLFid fid : fidList) {
            int vColumnNo = JoinPlanner.getVirtualColumnNumber(joinOrder, nColumns, fid);
            fid.removeProperty("sourceNo");
            fid.removeProperty("columnNo");
            fid.setVirtualColumnNo(vColumnNo);
        }
        for (QEPJoin plan : plans) {
            if (plan.getType() != 901014) continue;
            ((QEPMergeJoin)plan).fixVirtualColumnNumbers(joinOrder, nColumns);
        }
        CreateJoinPlan.injectParameterMappers(joinPlanner, plans);
        List<SQLFilter> list = qBlock.getFactorList();
        for (QEPJoin plan : plans) {
            IXQEQueryNode predicate = null;
            BitMask factors = plan.getFactors();
            Iterator<SQLFilter> fIterator = list.iterator();
            int j = 0;
            while (fIterator.hasNext()) {
                SQLFilter factor = fIterator.next();
                if (!factors.get(j++)) continue;
                if (plan.getJoins() != null && factor.getSubType() == 301011) {
                    if (factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) {
                        if (factor.getParent() == null) continue;
                        factor.getPredicate().detach();
                        factor.extract();
                        continue;
                    }
                    if (joinPlan.getJoinType() == XJoin.JoinType.INNER) continue;
                }
                if (predicate == null) {
                    predicate = factor.getPredicate().detach();
                } else {
                    SQLLogical qNode = (SQLLogical)factory.createNode(301027);
                    qNode.setSubType(SQLLogical.SubType.AND);
                    qNode.addChild(predicate);
                    qNode.addChild(factor.getPredicate().detach());
                    predicate = qNode;
                }
                factor.extract();
            }
            if (predicate == null) continue;
            plan.addChild(predicate);
        }
    }

    static void injectParameterMappers(Planner planner, List<QEPJoin> plans) {
        for (QEPJoin plan : plans) {
            if (!plan.isLateralJoin()) continue;
            ISQLQueryNode outerPlan = (ISQLQueryNode)plan.getChild(0);
            ISQLQueryNode innerPlan = (ISQLQueryNode)plan.getChild(1);
            IXQEQueryNode[] xidList = innerPlan.getDescendantsOfType(301082, false);
            SQLQueryItemList qItemList = outerPlan.getQueryItemList();
            SQLQueryItemList parameters = new SQLQueryItemList();
            for (int i = 0; i < xidList.length; ++i) {
                SQLXid xid = (SQLXid)xidList[i];
                SQLQueryItem qItem2 = qItemList.getParameterQueryItem(xid);
                if (qItem2 == null || parameters.contains(qItem2)) continue;
                parameters.add(qItem2);
            }
            QEPParameterMapper mapper = (QEPParameterMapper)planner.createPlan(901023);
            mapper.setQueryItemList(parameters);
            outerPlan.insertParent(mapper);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = !qBlock.isForeign();
        if (status) {
            if (node.getType() == 301014) {
                status = qBlock.getNumberOfFactors() > 0;
            } else {
                boolean bl2 = status = ((SQLJoin)node).getJoinType() != SQLJoin.SubType.CROSS;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Query block is a SQLProduct query block.", trace);
        } else {
            this.traceQueryCondition(status, "Query block is not a SQLProduct query block.", trace);
        }
        return status;
    }
}

