/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.qep.QEPJoin;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.Relation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.Planner;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;

public class CreateSemiJoinPlan
extends RQETransformation {
    public CreateSemiJoinPlan() {
        this.mName = "Create a hash semi-join plan.";
        this.mPassNumbers = new int[]{1};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301009};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        Planner planner = new Planner(environment);
        QEPJoin joinPlan = (QEPJoin)planner.createPlan(901015);
        SQLIn inNode = (SQLIn)node.getChild(1);
        IXQEQueryNode leftChild = inNode.getChild(0);
        ArrayList<Join> joins = new ArrayList<Join>();
        if (leftChild.getType() == 301032) {
            SQLFid fid = (SQLFid)leftChild.extract();
            joins.add(new Join(new Relation(fid.getVirtualColumnNo()), new Relation(0)));
        } else {
            int nChildren = leftChild.getNumberChildren();
            for (int i = 0; i < nChildren; ++i) {
                SQLFid fid = (SQLFid)leftChild.getChild(0).extract();
                joins.add(new Join(new Relation(fid.getVirtualColumnNo()), new Relation(i)));
            }
            leftChild.extract();
        }
        inNode.getChild(0).extract();
        inNode.extract();
        joinPlan.setJoinType(SQLJoin.SubType.SEMI);
        joinPlan.setJoins(joins);
        node.exchange(joinPlan, true);
        joinPlan.setNumberColumns(((ISQLQueryNode)joinPlan.getChild(0)).getNumberColumns());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLIn inNode;
        IXQEQueryNode predicate;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean status = false;
        if (!qBlock.isForeign() && (predicate = node.getChild(1)).getType() == 301076 && (inNode = (SQLIn)predicate).getChild(1).getType() == 301059) {
            IXQEQueryNode leftChild = inNode.getChild(0);
            if (leftChild.getType() == 301032) {
                status = true;
            } else if (leftChild.getType() == 301040) {
                status = true;
                for (IXQEQueryNode child : leftChild.getChildren()) {
                    if (child.getType() == 301032) continue;
                    status = false;
                    break;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Semi-join plan can be created.", trace);
        } else {
            this.traceQueryCondition(status, "Semi-join plan cannot be created.", trace);
        }
        return status;
    }
}

