/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class EliminateConstantFromWindows
extends RQETransformation {
    public EliminateConstantFromWindows() {
        this.mName = "Eliminate Constant From Windows PartitionBy and OrderBy Clause.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode sortKeyList;
        SQLWindow window = (SQLWindow)node.getFirstChildByType(301041);
        IXQEQueryNode partition = window.getFirstChildByType(301042);
        if (partition != null) {
            this.eliminateConstantExpression(partition);
        }
        if ((sortKeyList = window.getFirstChildByType(301021)) != null) {
            this.eliminateConstantExpression(sortKeyList);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLAggregate sqlNode = (SQLAggregate)node;
        boolean bl = status = pQueryBlock != null && pQueryBlock.isForeign();
        if (status) {
            boolean bl2 = status = this.hasConstantsInWindowsSpecification(sqlNode) && !pQueryBlock.getDataSource().getCapabilities().isSupported("supports.constantsInWindows");
        }
        if (status) {
            this.traceQueryCondition(status, "windows specification contains constants.", trace);
        } else {
            this.traceQueryCondition(status, "windows specification doesn't contain constants.", trace);
        }
        return status;
    }

    private boolean hasConstantsInWindowsSpecification(SQLAggregate node) {
        IXQEQueryNode sortKeyList;
        if (!node.hasChildOfType(301041)) {
            return false;
        }
        SQLWindow window = (SQLWindow)node.getFirstChildByType(301041);
        IXQEQueryNode partition = window.getFirstChildByType(301042);
        if (partition != null) {
            IXQEQueryNode[] partitionList;
            for (IXQEQueryNode partitionNode : partitionList = partition.getChildren()) {
                if (!(partitionNode instanceof SQLExpression) || !((SQLExpression)partitionNode).isConstantExpression()) continue;
                return true;
            }
        }
        if ((sortKeyList = window.getFirstChildByType(301021)) != null) {
            IXQEQueryNode[] sortKeys;
            for (IXQEQueryNode sortKeyNode : sortKeys = sortKeyList.getChildren()) {
                if (!(sortKeyNode instanceof SQLExpression) || !((SQLExpression)sortKeyNode).isConstantExpression()) continue;
                return true;
            }
        }
        return false;
    }

    private IXQEQueryNode eliminateConstantExpression(IXQEQueryNode node) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = node.getChildren()) {
            if (!((SQLExpression)child).isConstantExpression()) continue;
            child.detach();
        }
        if (node.getNumberChildren() == 0) {
            node.detach();
            node = null;
        }
        return node;
    }
}

