/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public final class FlattenNativeQuery
extends RQETransformation {
    static int[] anchors = new int[]{301004, 301059, 301023, 301018, 601013};

    public FlattenNativeQuery() {
        this.mName = "Flatten a native query node.";
        this.mPassNumbers = new int[]{10};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLValueList outerProjList = (SQLValueList)node.detachSecondChild();
        SQLQueryNode parent = (SQLQueryNode)node.getParent();
        int childNo = parent.getPositionOfChild(node);
        parent.getChild(childNo).extract();
        parent.getChild(childNo).extract();
        SQLValueList innerProjectList = ((SQLQueryNode)parent.getChild(childNo)).getOutputList();
        if (innerProjectList != null) {
            SQLSort sort;
            ArrayList<SQLAlias> innerAliasList = null;
            int nChildren = outerProjList.getNumberChildren();
            innerAliasList = new ArrayList<SQLAlias>(nChildren);
            for (int i = 0; i < nChildren; ++i) {
                SQLAlias aliasNode = new SQLAlias();
                aliasNode.setName(outerProjList.getName(i));
                innerAliasList.add(aliasNode);
            }
            innerProjectList.setAliasList(innerAliasList);
            if (parent.getChild(childNo).getType() == 301018) {
                ((SQLSetOperator)parent.getChild(childNo)).alignColumnNames(innerAliasList);
            }
            if (parent.getType() == 301008 && parent.getChild(0).getType() == 301008) {
                parent.getChild(0).extract();
            }
            if ((sort = FlattenNativeQuery.getSortNodeIfExists(parent)) != null) {
                List<IXQEQueryNode> fidList = sort.getChild(1).getDescendantsOfTypeOrdered(301032, false);
                for (int i = 0; i < fidList.size(); ++i) {
                    SQLFid fid = (SQLFid)fidList.get(i);
                    fid.setName(innerProjectList.getName(fid.getVirtualColumnNo()));
                    fid.setTableName(innerProjectList.getQualifier(fid.getVirtualColumnNo()));
                }
            }
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode projList;
        int nColumns;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode nextChild = node.getChild(0);
        if (((SQLProject)node).isCollapsible() && nextChild.getType() == 301007 && (nextChild = nextChild.getChild(0)).getType() != 301016 && nextChild.getType() != 301039 && nextChild.getType() != 301038 && nextChild.getType() != 301092 && nextChild.getType() != 301012 && nextChild.getType() != 301091 && nextChild.getType() != 301060 && nextChild.getType() != 301019 && (nextChild.getType() != 301018 && nextChild.getType() != 301022 || node.getParent().getType() != 301008) && (nColumns = ((SQLQueryNode)nextChild).getNumberColumns()) > 0 && (projList = node.getChild(1)).getNumberChildren() == nColumns) {
            status = true;
            for (int i = 0; i < projList.getNumberChildren(); ++i) {
                IXQEQueryNode exprNode = projList.getChild(i);
                if (exprNode.getType() == 301032 && ((SQLFid)exprNode).getVirtualColumnNo() == i) continue;
                status = false;
                break;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Projection can be eliminated.", trace);
        } else {
            this.traceQueryCondition(status, "Projection can not be eliminated.", trace);
        }
        return status;
    }

    private static SQLSort getSortNodeIfExists(IXQEQueryNode node) {
        if (node.getType() == 301019) {
            return (SQLSort)node;
        }
        if ((node = node.getParent()).getType() == 301019) {
            return (SQLSort)node;
        }
        return null;
    }
}

