/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class NormalizeComparisonsWithNotOperator
extends RQETransformation {
    public NormalizeComparisonsWithNotOperator() {
        this.mName = "Normalize SQLComparison node with NOT operator.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301026};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLComparison comparison = (SQLComparison)node;
        comparison.getParent().extract();
        comparison.invertSubType();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = ((SQLQueryNode)node).getParentQueryBlock();
        boolean bl = status = !qBlock.isForeign();
        if (status) {
            if (node.getParent().getType() == 301027) {
                SQLLogical logical = (SQLLogical)node.getParent();
                if (logical.getSubType() != SQLLogical.SubType.NOT) {
                    status = false;
                }
            } else {
                status = false;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Comparison operator needs to be inverted.", trace);
        } else {
            this.traceQueryCondition(status, "Comparison operator doesn't need to be inverted.", trace);
        }
        return status;
    }
}

