/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.optimization.PushSQLSort;

public class NormalizeSQLSort
extends PushSQLSort {
    public NormalizeSQLSort() {
        this.mName = "Normalize sort node in foreign query block.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSourceCapabilities capabilities = qBlock.getDataSource().getCapabilities();
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 301022) {
            child = child.getChild(child.getNumberChildren() - 1);
            IXQEQueryNode sortKeyList = node.getChild(1).detach();
            node.extract();
            child.insertParent(node);
            node.addChild(sortKeyList);
        }
        this.applyTransformation(environment, capabilities, node);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = node.getPropertyValue("NormalizeSQLSortApplied") != Boolean.TRUE && qBlock != null && qBlock.isForeign();
        if (status) {
            this.traceQueryCondition(status, "Sort can be normalized.", trace);
        } else {
            this.traceQueryCondition(status, "Sort cannot be normalized.", trace);
        }
        return status;
    }
}

