/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public class NormalizeXMLFunction
extends RQETransformation {
    public NormalizeXMLFunction() {
        this.mName = "Normalize an XML scalar function node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301030};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLValueList vList = (SQLValueList)node;
        List<SQLAlias> aliasList = vList.getAliasList();
        IXQEQueryNode[] children = vList.getChildren();
        IXQEQueryNode parent = node.getParent();
        int position = 1;
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode eNode = children[i];
            SQLAlias alias = null;
            if (aliasList != null) {
                alias = aliasList.get(i);
            }
            String name = null;
            if (alias != null) {
                name = alias.getName();
            } else if (parent.getType() != 301038 && eNode.getType() == 301032) {
                name = ((SQLFid)eNode).getName();
            }
            if (name != null) {
                SQLIdentifier qNode = (SQLIdentifier)factory.createNode(301067);
                qNode.setName(name);
                vList.addChild(qNode, position);
            } else {
                vList.addChild(factory.createNode(301070), position);
            }
            position += 2;
        }
        vList.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = !pQueryBlock.isForeign();
        if (status) {
            SQLFunction.SubType subType;
            IXQEQueryNode parent = node.getParent();
            status = parent.getType() == 301038 ? ((SQLTableFunction)parent).getSubType() == SQLTableFunction.SubType.XMLTABLE : (parent.getType() == 301033 ? (subType = ((SQLFunction)parent).getSubType()) == SQLFunction.SubType.XMLEXISTS || subType == SQLFunction.SubType.XMLQUERY || subType == SQLFunction.SubType.XMLFOREST || subType == SQLFunction.SubType.XMLATTRIBUTES || subType == SQLFunction.SubType.XMLNAMESPACES : false);
        }
        if (status) {
            this.traceQueryCondition(status, "XML function needs to be normalized.", trace);
        } else {
            this.traceQueryCondition(status, "XML function doesn't need to be normalized.", trace);
        }
        return status;
    }
}

