/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLOrdinal;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PushSQLSort
extends RQETransformation {
    protected static final String NORMALIZE_SQL_SORT_APPLIED = "NormalizeSQLSortApplied";

    public PushSQLSort() {
        this.mName = "Push sort node into foreign query block.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLSort sort = (SQLSort)node;
        IXQEQueryNode child = sort.getChild(0);
        IDataSourceCapabilities capabilities = ((SQLQueryBlock)child).getDataSource().getCapabilities();
        IXQEQueryNode sortKeyList = sort.getChild(1).detach();
        sort.extract();
        child = child.getChild(0);
        if (child.getType() == 301022) {
            child = child.getChild(child.getNumberChildren() - 1);
        }
        child.insertParent(sort);
        sort.addChild(sortKeyList);
        this.applyTransformation(environment, capabilities, sort);
    }

    protected void applyTransformation(IPlanningEnvironment environment, IDataSourceCapabilities capabilities, IXQEQueryNode node) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSort sort = (SQLSort)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean supportsOrderByName = capabilities.getBooleanValue("supports.orderByName");
        boolean supportsOrderByAlias = capabilities.getBooleanValue("supports.orderByAlias");
        boolean supportsOrderByOrdinal = capabilities.getBooleanValue("supports.orderByOrdinal");
        IXQEQueryNode child = sort.getChild(0);
        while (child.getType() != 301015 && child.getType() != 301010) {
            child = child.getChild(0);
        }
        SQLValueList valueList = ((SQLProject)child).getOutputList();
        List<SQLAlias> aliasList = valueList.getAliasList();
        if (supportsOrderByAlias && aliasList == null) {
            aliasList = new ArrayList<SQLAlias>();
            for (int i = 0; i < valueList.getNumberChildren(); ++i) {
                aliasList.add(null);
            }
            valueList.setAliasList(aliasList);
        }
        SQLSortKeyList ordering = (SQLSortKeyList)sort.getChild(1);
        UniqueAliasHelper helper = new UniqueAliasHelper(valueList);
        for (int i = 0; i < ordering.getNumberChildren(); ++i) {
            SQLAlias aliasNode;
            SQLFid fid;
            SQLSortKey orderItem = (SQLSortKey)ordering.getChild(i);
            child = orderItem.getChild(0);
            if (child.getType() == 301066) {
                if (supportsOrderByOrdinal) continue;
                fid = (SQLFid)nodeFactory.createNode(301032);
                fid.setVirtualColumnNo(((SQLOrdinal)child).getValue() - 1);
                fid.setDataType(((SQLOrdinal)child).getDataType());
                child.exchange(fid);
                child = fid;
            }
            if (child.getType() != 301032) continue;
            fid = (SQLFid)child;
            int columnNo = fid.getVirtualColumnNo();
            if (supportsOrderByName && orderItem.isUnrelated() || columnNo >= valueList.getNumberChildren()) continue;
            IXQEQueryNode value = valueList.getChild(columnNo);
            if (supportsOrderByAlias && supportsOrderByName) {
                aliasNode = aliasList.get(columnNo);
                if (aliasNode == null) {
                    if (value.getType() == 301032) {
                        fid.setQualifiers((SQLFid)value);
                        fid.setName(((SQLFid)value).getName());
                    } else {
                        aliasNode = (SQLAlias)nodeFactory.createNode(301028);
                        aliasNode.setName(helper.makeUniqueAlias(columnNo));
                        aliasList.set(columnNo, aliasNode);
                    }
                }
                if (aliasNode != null) {
                    fid.dropQualifiers();
                    fid.setName(aliasNode.getName());
                }
            } else if (supportsOrderByAlias) {
                aliasNode = aliasList.get(columnNo);
                if (aliasNode == null) {
                    aliasNode = (SQLAlias)nodeFactory.createNode(301028);
                    aliasNode.setName(helper.makeUniqueAlias(columnNo));
                    aliasList.set(columnNo, aliasNode);
                }
                fid.dropQualifiers();
                fid.setName(aliasNode.getName());
            } else if (supportsOrderByName) {
                SQLAlias sqlAlias;
                String alias = null;
                if (aliasList != null && (sqlAlias = aliasList.get(columnNo)) != null) {
                    alias = sqlAlias.getName();
                }
                if ((fid.getName() == null || alias != null && fid.getName().equals(alias)) && value.getType() == 301032) {
                    fid.setQualifiers((SQLFid)value);
                    fid.setName(((SQLFid)value).getName());
                } else if (supportsOrderByOrdinal) {
                    SQLOrdinal ordinal = (SQLOrdinal)nodeFactory.createNode(301066);
                    ordinal.setValue(columnNo + 1);
                    fid.exchange(ordinal, true);
                } else {
                    fid.exchange(value, true);
                }
            } else {
                SQLOrdinal ordinal = (SQLOrdinal)nodeFactory.createNode(301066);
                ordinal.setValue(columnNo + 1);
                fid.exchange(ordinal, true);
            }
            if (!capabilities.isSupported("general.nullsOrdering") || orderItem.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED) continue;
            orderItem.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
        }
        int nSortKeys = ordering.getNumberChildren();
        SQLSortKey.NullOrdering[] nullOrdering = new SQLSortKey.NullOrdering[nSortKeys];
        for (int i = 0; i < nSortKeys; ++i) {
            SQLSortKey orderItem = (SQLSortKey)ordering.getChild(i);
            nullOrdering[i] = orderItem.getNullOrder();
        }
        qBlock.setNullOrdering(nullOrdering);
        node.setPropertyValue(NORMALIZE_SQL_SORT_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLSort sort = (SQLSort)node;
        boolean bl = status = sort.isPushable() && this.pushableSort((IExecutionEnvironment)environment.getExecutionEnvironment(), sort, node.getChild(0));
        if (status) {
            this.traceQueryCondition(status, "Sort can be pushed to a foreign query block.", trace);
        } else {
            this.traceQueryCondition(status, "Sort cannot be pushed to a foreign query block.", trace);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pushableSort(IExecutionEnvironment env, SQLSort sort, IXQEQueryNode root) {
        if (root.getType() != 301004 || !((SQLQueryBlock)root).isForeign() || ((SQLQueryBlock)root).getReusableQuery() != null) {
            return false;
        }
        IDataSource dataSource = ((SQLQueryBlock)root).getDataSource();
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        boolean supportsExpressionsInOrderBy = capabilities.isSupported("supports.expressionsInOrderBy");
        boolean supportsOrderByAlias = capabilities.isSupported("supports.orderByAlias");
        boolean supportsOrderByOrdinal = capabilities.isSupported("supports.orderByOrdinal");
        IXQEQueryNode child = root.getChild(0);
        if (child.getType() == 301019 || child.getType() == 301012 || child.getType() == 301091 || child.getType() == 301061) {
            return false;
        }
        if (child.getType() == 301022) {
            child = child.getChild(child.getNumberChildren() - 1);
        }
        while (child.getType() != 301015 && child.getType() != 301010) {
            child = child.getChild(0);
        }
        SQLValueList valueList = ((SQLProject)child).getOutputList();
        List<SQLAlias> aliasList = valueList.getAliasList();
        SQLSortKeyList sortKeyList = sort.getSortKeyList();
        boolean result = SQLSort.isFeatureSupported(capabilities);
        if (result) {
            int maxColumnsInOrderBy = capabilities.getIntegerValue("limits.maxColumnsInOrderBy");
            boolean bl = result = maxColumnsInOrderBy <= 0 || sortKeyList.getNumberChildren() <= maxColumnsInOrderBy;
            if (result) {
                result = sortKeyList.isSupported(dataSource);
            }
        }
        if (result) {
            for (int i = 0; i < sortKeyList.getNumberChildren() && result; ++i) {
                IXQEQueryNode value;
                SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
                IXQEQueryNode sortKeyExpr = sortKey.getChild(0);
                if (!(sortKeyExpr.getType() != 301032 || supportsExpressionsInOrderBy || supportsOrderByAlias || supportsOrderByOrdinal || aliasList == null || aliasList.size() < sortKeyList.getNumberChildren())) {
                    String alias = null;
                    SQLAlias sqlAlias = aliasList.get(((SQLFid)sortKeyExpr).getVirtualColumnNo());
                    IXQEQueryNode value2 = valueList.getChild(((SQLFid)sortKeyExpr).getVirtualColumnNo());
                    if (sqlAlias != null) {
                        alias = sqlAlias.getName();
                    }
                    if (((SQLFid)sortKeyExpr).getName() == null) {
                        result = false;
                        continue;
                    }
                    if (alias == null || !((SQLFid)sortKeyExpr).getName().equals(alias) || value2.getType() == 301032) continue;
                    result = false;
                    break;
                }
                if (sortKeyExpr.getType() != 301066 || supportsOrderByOrdinal || (value = valueList.getChild(((SQLOrdinal)sortKeyExpr).getValue() - 1)).getType() == 301032) continue;
                result = false;
                break;
            }
        }
        if (result && sortKeyList.containNotSupportedNullOrdering(dataSource)) {
            result = sort.isNullOrderingConvertableToCase(dataSource);
        }
        if (result && sort.isCollationIdRequired()) {
            IRelationalDataProvider provider = ProviderManager.getInstance().getRelationalProvider(dataSource.getType());
            IConnectionPool connectionPool = env.getConnectionPool();
            ConnectionParameters parameters = new ConnectionParameters();
            parameters.put(new DataSourceParameter(dataSource));
            parameters.put(new RunLocaleParameter(env.getRequestEnvironment().getRunLocale(), false));
            IPooledConnection pooledConnection = connectionPool.borrowConnection(provider.getProviderInstanceName(), parameters, provider.getConnectionSelector(), provider.getConnectionFactory());
            try {
                for (int i = 0; i < sortKeyList.getNumberChildren() && result; ++i) {
                    SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
                    if (!sortKey.getDataType().isTextType()) continue;
                    result = env.getLocalSortIsCompatibleWithServer((AbstractConnection)pooledConnection.getConnection());
                }
            }
            finally {
                pooledConnection.returnConnection();
            }
        }
        return result;
    }

    private static class UniqueAliasHelper {
        private static final String ALIAS_PREFIX = "C";
        Set<String> uniqueNames = new HashSet<String>();

        UniqueAliasHelper(SQLValueList valueList) {
            for (int i = 0; i < valueList.getNumberChildren(); ++i) {
                if (valueList.getAlias(i) != null) {
                    this.uniqueNames.add(valueList.getAlias(i));
                    continue;
                }
                if (valueList.getChild(i).getType() != 301032) continue;
                this.uniqueNames.add(((SQLFid)valueList.getChild(i)).getName());
            }
        }

        private String makeUniqueAlias(int columnNo) {
            String name = ALIAS_PREFIX + columnNo;
            while (this.uniqueNames.contains(name)) {
                name = ALIAS_PREFIX + name;
            }
            this.uniqueNames.add(name);
            return name;
        }
    }
}

