/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class RemoveOptionalCastFromNativeSQL
extends RQETransformation {
    public static final String FALSE = "false";
    public static final String TRUE = "true";

    public RemoveOptionalCastFromNativeSQL() {
        this.mName = "Remove Optional Cast from Native SQL.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301047};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        node.getChild(1).extract();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock;
        XQETrace trace = environment.getTrace();
        IDataSource dataSource = null;
        boolean status = false;
        SQLCast castNode = (SQLCast)node;
        if (castNode.isOptional() && (qBlock = (SQLQueryBlock)node.getAncestorOfType(301004)) != null && qBlock.isForeign()) {
            dataSource = qBlock.getDataSource();
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            status = capabilities.getStringValue("supports.integerDivision", FALSE).equals(FALSE);
        }
        if (status) {
            this.traceQueryCondition(status, "Optional CAST can be removed.", trace);
        } else {
            this.traceQueryCondition(status, "Optional Cast can not be removed.", trace);
        }
        return status;
    }
}

