/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.util.RQEUtil;

public class RemoveQueryBlocks
extends RQETransformation {
    public RemoveQueryBlocks() {
        this.mName = "Remove extraneous query blocks.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        RQEUtil.transferNoCacheToDescendants(qBlock);
        IXQEQueryNode parent = node.getParent();
        if (environment.isBigSQL() && parent.getType() == 401005) {
            V5QuerySet querySet = (V5QuerySet)parent.getParent();
            querySet.setQueryItemList(qBlock.getQueryItemList());
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        boolean bl = status = !qBlock.isForeign() && !qBlock.isLateralDerivedTable() && !qBlock.hasParameters() && !qBlock.isRecursive() && qBlock.getReusableQuery() == null;
        if (status) {
            this.traceQueryCondition(status, "Query block is not a foreign query block.", trace);
        } else {
            this.traceQueryCondition(status, "Query block is a foreign query block.", trace);
        }
        return status;
    }
}

