/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class RemoveSQLDistinct
extends RQETransformation {
    public RemoveSQLDistinct() {
        this.mName = "Remove SQLDistinct node.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{301008};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode parent = node.getParent();
        SQLSort sortNode = null;
        sortNode = parent.getType() == 301022 ? (SQLSort)parent.getParent() : (SQLSort)parent;
        SQLSortKeyList sortKeyList = (SQLSortKeyList)sortNode.getChild(1);
        sortNode.setDistinct(true);
        IXQEQueryNode vList = node.getChild(0).getChild(1);
        if (vList.getNumberChildren() != sortKeyList.getNumberChildren()) {
            RemoveSQLDistinct.adjustSortList(nodeFactory, sortKeyList, vList);
        }
        node.extract();
    }

    public static void adjustSortList(XQENodeFactory nodeFactory, SQLSortKeyList sortKeyList, IXQEQueryNode vList) {
        int nSortKeys = sortKeyList.getNumberChildren();
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            if (((SQLExpression)vList.getChild(i)).isConstantValue()) continue;
            boolean found = false;
            for (int j = 0; j < nSortKeys && !found; ++j) {
                SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(j);
                found = sortKey.getColumnNo() == i;
            }
            if (found) continue;
            sortKeyList.addSortKey(nodeFactory, i, ((SQLQueryNode)vList.getChild(i)).getDataType(), true, SQLSortKey.NullOrdering.UNSPECIFIED);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean bl = status = (pQueryBlock == null || !pQueryBlock.isForeign()) && node.getChild(0).getType() == 301015;
        if (status) {
            IXQEQueryNode parent = node.getParent();
            int type = parent.getType();
            if (type == 301022) {
                parent = parent.getParent();
                type = parent.getType();
            }
            boolean bl2 = status = type == 301019;
        }
        if (status) {
            this.traceQueryCondition(status, "SORT and DISTINCT nodes can be collapsed.", trace);
        } else {
            this.traceQueryCondition(status, "SORT and DISTINCT nodes cannot be collapsed.", trace);
        }
        return status;
    }
}

