/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.qep.QEPMergeJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public class ResolveNullOrdering
extends RQETransformation {
    public ResolveNullOrdering() {
        this.mName = "Resolve null ordering for merge join.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{901014};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLSortKey sortKey;
        int i;
        IDataSource dataSource = null;
        List<IXQEQueryNode> sortNodes = node.getFirstDescendantsOfTypeOrdered(301019, false);
        SQLQueryBlock qBlock = (SQLQueryBlock)sortNodes.get(0).getFirstDescendantOfTypeOrdered(301004, false);
        if (qBlock != null) {
            dataSource = qBlock.getDataSource();
        }
        SQLSortKeyList sortKeyList = (SQLSortKeyList)sortNodes.get(0).getChild(1);
        int nJoinKeys = ((QEPMergeJoin)node).getJoins().size();
        SQLSortKey.NullOrdering[] nullOrdering = new SQLSortKey.NullOrdering[nJoinKeys];
        for (i = 0; i < nJoinKeys; ++i) {
            nullOrdering[i] = SQLSortKey.NullOrdering.NULLS_LAST;
        }
        if (dataSource != null) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            for (int i2 = 0; i2 < Math.min(nJoinKeys, sortKeyList.getNumberChildren()); ++i2) {
                sortKey = (SQLSortKey)sortKeyList.getChild(i2);
                if (sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED) {
                    nullOrdering[i2] = sortKey.getNullOrder();
                    continue;
                }
                if (capabilities.isSupported("general.nullsAreSortedLow")) {
                    nullOrdering[i2] = sortKey.isAscending() ? SQLSortKey.NullOrdering.NULLS_FIRST : SQLSortKey.NullOrdering.NULLS_LAST;
                }
                if (capabilities.isSupported("general.nullsAreSortedHigh")) {
                    nullOrdering[i2] = sortKey.isAscending() ? SQLSortKey.NullOrdering.NULLS_LAST : SQLSortKey.NullOrdering.NULLS_FIRST;
                }
                if (capabilities.isSupported("general.nullsAreSortedAtStart")) {
                    nullOrdering[i2] = SQLSortKey.NullOrdering.NULLS_FIRST;
                }
                if (!capabilities.isSupported("general.nullsAreSortedAtEnd")) continue;
                nullOrdering[i2] = SQLSortKey.NullOrdering.NULLS_LAST;
            }
        }
        for (i = 0; i < sortNodes.size(); ++i) {
            sortKeyList = (SQLSortKeyList)sortNodes.get(i).getChild(1);
            for (int j = 0; j < Math.min(nJoinKeys, sortKeyList.getNumberChildren()); ++j) {
                sortKey = (SQLSortKey)sortKeyList.getChild(j);
                if (sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED) continue;
                sortKey.setNullOrder(nullOrdering[j]);
            }
        }
        ((QEPMergeJoin)node).setNullOrdering(nullOrdering);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((QEPMergeJoin)node).getNullOrdering() == null;
        if (status) {
            this.traceQueryCondition(status, "Null ordering has not been resolved.", trace);
        } else {
            this.traceQueryCondition(status, "Null ordering has been resolved.", trace);
        }
        return status;
    }
}

