/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLXid;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class ResolveParametersForLateralDerivedTable
extends RQETransformation {
    public ResolveParametersForLateralDerivedTable() {
        this.mName = "Generate parameters for lateral derived table.";
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] xidList;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IDataSource dataSource = ((SQLQueryBlock)node).getDataSource();
        boolean useParameterizedSQL = dataSource != null && dataSource.getCapabilities().isSupported("supports.parameterMarkers");
        for (IXQEQueryNode fid : xidList = node.getChild(0).getDescendantsOfType(301082, false)) {
            SQLXid xid = (SQLXid)fid;
            SQLParameter parameter = (SQLParameter)nodeFactory.createNode(301051);
            parameter.setName(xid.getParameterName());
            parameter.setDataType(xid.getDataType());
            parameter.setUseParameterizedSQL(useParameterizedSQL);
            xid.exchange(parameter);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        boolean bl = status = qBlock.isLateralDerivedTable() && qBlock.getDescendantsOfType(301082, false).length > 0;
        if (status) {
            this.traceQueryCondition(status, "Parameters need to be generated.", trace);
        } else {
            this.traceQueryCondition(status, "Parameters do not need to be generated.", trace);
        }
        return status;
    }
}

