/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLOrdinalDecoration;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.RestoreOlapMemberOrderUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class RestoreOlapMemberOrderForOrderDependentAggragates
extends RQETransformation {
    public RestoreOlapMemberOrderForOrderDependentAggragates() {
        this.mName = "Restore Olap member order for aggragates dependent on tabular stream row order (running/moving).";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{901020, 901021};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode nodeStart = node;
        if (nodeStart.getType() == 901020) {
            nodeStart = node.getChild(0);
        }
        SQLOrdinalDecoration rowNumber = RestoreOlapMemberOrderUtil.createOrderColumn(nodeStart, nodeFactory);
        int columnNo = rowNumber.getNumberColumns() - 1;
        SQLValueList valueList = (SQLValueList)node.getFirstChildByType(301030);
        SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
        fid.setSourceNo(0);
        fid.setColumnNo(columnNo);
        fid.setVirtualColumnNo(columnNo);
        fid.setDataType(DataTypeFactory.getLongType());
        fid.setName(rowNumber.getOrderColumnName());
        SQLAggregate agg = (SQLAggregate)nodeFactory.createNode(301034);
        agg.setSubType(SQLAggregate.SubType.MIN);
        agg.addChild(fid);
        if (valueList.getAliasList() != null) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(fid.getName());
            valueList.getAliasList().add(aliasNode);
        }
        valueList.addChild(agg);
        RestoreOlapMemberOrderUtil.propagateOrderColumn(fid, nodeFactory);
        RestoreOlapMemberOrderUtil.createSortByOrderColumn(node, nodeFactory);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status = RestoreOlapMemberOrderUtil.isOlapBased(node);
        String msg = status ? "Group by over OLAP" : "Group by is not over OLAP";
        if (status) {
            status = false;
            for (SQLProject project = (SQLProject)node.getAncestorOfType(301015); project != null; project = (SQLProject)project.getAncestorOfType(301015)) {
                if (!project.getMemberOrdered()) continue;
                status = true;
                msg = msg + " with running/moving function";
                break;
            }
        }
        if (status && RestoreOlapMemberOrderUtil.explicitlySortedResultset(node)) {
            status = false;
            msg = "Sorted result set.";
        }
        this.traceQueryCondition(status, msg, environment.getTrace());
        return status;
    }
}

