/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLOrdinalDecoration;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.RestoreOlapMemberOrderUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class RestoreOlapMemberOrderSortedForAggregation
extends RQETransformation {
    public RestoreOlapMemberOrderSortedForAggregation() {
        this.mName = "Restore Olap member order sorted for windowed aggregation.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301019};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode project = node.getAncestorOfType(301015);
        SQLOrdinalDecoration rowNumber = RestoreOlapMemberOrderUtil.createOrderColumn(node, nodeFactory);
        int columnNo = rowNumber.getNumberColumns() - 1;
        SQLValueList valueList = (SQLValueList)project.getFirstChildByType(301030);
        SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
        fid.setSourceNo(0);
        fid.setColumnNo(columnNo);
        fid.setVirtualColumnNo(columnNo);
        fid.setDataType(DataTypeFactory.getLongType());
        fid.setName(rowNumber.getOrderColumnName());
        if (valueList.getAliasList() != null) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(fid.getName());
            valueList.getAliasList().add(aliasNode);
        }
        valueList.addChild(fid);
        RestoreOlapMemberOrderUtil.propagateOrderColumn(fid, nodeFactory);
        RestoreOlapMemberOrderUtil.createSortByOrderColumn(project, nodeFactory);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        Boolean att = node.getBooleanPropertyValue("window.aggregate");
        boolean bl = status = att != null && att == Boolean.TRUE;
        if (status) {
            boolean bl2 = status = node.getFirstDescendantOfTypeOrdered(301052, false) != null;
        }
        if (status) {
            V5QuerySet querySet = RestoreOlapMemberOrderUtil.getTopMostQuerySet(node);
            if (querySet == null) {
                status = false;
            } else {
                Boolean sub = querySet.getBooleanPropertyValue("MultiDimensionalSubquery");
                boolean bl3 = status = sub == null || sub == Boolean.FALSE;
            }
        }
        if (status) {
            boolean bl4 = status = !RestoreOlapMemberOrderUtil.explicitlySortedResultset(node);
        }
        if (status) {
            this.traceQueryCondition(status, "Projection has sorted stream for window aggregation over OLAP", trace);
        } else {
            this.traceQueryCondition(status, "Projection does not have sorted stream for window aggregation over OLAP", trace);
        }
        return status;
    }
}

