/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.ConnectionUtil;

public class RewriteCastClobToVarchar
extends RQETransformation {
    private static final int DEFAULT_VARCHAR_LENGTH = 1024;

    public RewriteCastClobToVarchar() {
        this.mName = "RewriteCastClobToVarchar";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301047};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQELogger clobLogger;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        int maxVarcharSize = 1024;
        String msgToLog = new String();
        boolean needToAddSubstring = true;
        boolean canCastToNVarchar = false;
        boolean shouldCastToNVarchar = false;
        if (dataSource != null) {
            AbstractConnection connection;
            Object executionEnv = environment.getExecutionEnvironment();
            IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(executionEnv, dataSource);
            if (dataSource.getCapabilities() != null) {
                maxVarcharSize = dataSource.getCapabilities().getIntegerValue("limits.castClobToVarcharMaxSize");
                needToAddSubstring = !dataSource.getCapabilities().getBooleanValue("supports.castClobToVarcharWithoutSubstring");
                canCastToNVarchar = dataSource.getCapabilities().getBooleanValue("dataType.nvarchar");
                msgToLog = "The varchar size " + maxVarcharSize + " will be used for casting clobs to varchar, as per the limits.castClobToVarcharMaxSize property for database vendor '" + dataSource.getType() + "'.";
            }
            if ((connection = (AbstractConnection)pooledConnection.getConnection()) instanceof JDBCConnection) {
                JDBCConnection jdbcConn = (JDBCConnection)connection;
                shouldCastToNVarchar = jdbcConn.castToNvarchar();
                if (((JDBCConnection)connection).getMaxVarcharSize() != -1) {
                    if (jdbcConn.getMaxVarcharSize() >= 1024 || jdbcConn.getMaxVarcharSize() >= maxVarcharSize) {
                        maxVarcharSize = jdbcConn.getMaxVarcharSize();
                        msgToLog = "The varchar size " + maxVarcharSize + " will be used for casting clobs to varchar, as per the datasource connection property '" + "ibmcognos.maxvarcharsize" + "'. ";
                    } else {
                        if (maxVarcharSize > 1024) {
                            maxVarcharSize = 1024;
                            msgToLog = "The default varchar size 1024 will be used for casting clobs to varchar.";
                        }
                        msgToLog = msgToLog + " The datasource connection property 'ibmcognos.maxvarcharsize' has a value of " + jdbcConn.getMaxVarcharSize() + ", which is too low. ";
                    }
                }
            }
            pooledConnection.returnConnection();
        }
        if (!msgToLog.isEmpty() && (clobLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Clobs", LogLevel.INFO)).isOn(LogLevel.INFO)) {
            clobLogger.log(msgToLog);
        }
        if (canCastToNVarchar && shouldCastToNVarchar) {
            maxVarcharSize /= 2;
        }
        SQLCast sqlCast = (SQLCast)node;
        IXQEQueryNode firstChild = sqlCast.getChild(0);
        if (needToAddSubstring) {
            firstChild.detach();
            SQLFunction sqlFunction = (SQLFunction)nodeFactory.createNode(301033);
            sqlFunction.setSubType(SQLFunction.SubType.SUBSTRING);
            sqlFunction.addChild(firstChild);
            SQLLiteral from = (SQLLiteral)nodeFactory.createNode(301031);
            SQLLiteral to = (SQLLiteral)nodeFactory.createNode(301031);
            from.setDataType(DataTypeFactory.getSmallintType());
            from.setValue("1");
            to.setDataType(DataTypeFactory.getSmallintType());
            to.setValue(Integer.toString(maxVarcharSize));
            sqlFunction.addChild(from);
            sqlFunction.addChild(to);
            sqlCast.addFirstChild(sqlFunction);
        }
        SQLDataType sqlDataType = (SQLDataType)sqlCast.getFirstChildByType(301037);
        VarcharType newDT = canCastToNVarchar && shouldCastToNVarchar ? DataTypeFactory.getNVarcharType(maxVarcharSize) : DataTypeFactory.getVarcharType(maxVarcharSize);
        sqlDataType.setDataType(newDT);
        node.removeProperty("needToAdjustToVarcharSize");
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        return node.getPropertyValue("needToAdjustToVarcharSize") != null;
    }
}

