/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.DecomposeSQLGroupByWithWindowedAggregates;
import java.util.ArrayList;
import java.util.List;

public class RewriteGroupedWindowedTable
extends RQETransformation {
    private static final String DERIVED_TABLE_NAME = "D1";

    public RewriteGroupedWindowedTable() {
        this.mName = "Decompose a SQLGroupBy node with windowed aggregates.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock qBlock = DecomposeSQLGroupByWithWindowedAggregates.doTransformation(node, environment);
        ((SQLQueryBlock)qBlock.getAncestorOfType(301004)).setForeign(true);
        qBlock.setName(DERIVED_TABLE_NAME);
        SQLGroupBy groupBy = (SQLGroupBy)qBlock.getChild(0);
        SQLValueList vList = groupBy.getOutputList();
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName("C" + i);
            aliasList.add(aliasNode);
        }
        vList.setAliasList(aliasList);
        vList = ((SQLProject)qBlock.getParent()).getOutputList();
        List<SQLAlias> aliasList2 = vList.getAliasList();
        if (aliasList2 == null) {
            aliasList2 = new ArrayList<SQLAlias>();
            for (int i = 0; i < vList.getNumberChildren(); ++i) {
                aliasList2.add(null);
            }
        }
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            if (aliasList2.get(i) != null || vList.getChild(i).getType() != 301032) continue;
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(((SQLFid)vList.getChild(i)).getName());
            aliasList2.set(i, aliasNode);
        }
        List<IXQEQueryNode> fids = vList.getDescendantsOfTypeOrdered(301032, 301059);
        for (IXQEQueryNode ixqeQueryNode : fids) {
            SQLFid fid = (SQLFid)ixqeQueryNode;
            fid.setName(((SQLAlias)aliasList.get(fid.getVirtualColumnNo())).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
        }
        SQLRangeVar rangeVar = (SQLRangeVar)environment.getNodeFactory().createNode(301007);
        rangeVar.setName(qBlock.getName());
        qBlock.exchange(rangeVar, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        boolean status = qBlock.isForeign();
        if (status) {
            status = ((SQLQueryNode)node).getOutputList().hasWindowedAggregates();
        }
        if (status) {
            boolean bl = status = !dataSource.getCapabilities().isSupported("supports.groupedWindowedTables");
        }
        if (status) {
            this.traceQueryCondition(status, "Grouped Windowed Table is not supported.", trace);
        } else {
            this.traceQueryCondition(status, "Grouped Windowed Table is supported.", trace);
        }
        return status;
    }
}

